/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.Competitor;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class TotalScoresPane
extends AbstractF3KScoreEditorPanel {
    private String[] colNames;
    private int[] colWidths;
    private boolean useSecondNameColumn;
    private int firstRoundCol;
    private int lastRoundCol;
    private int secondNameCol = -1;
    private int penaltyCol;
    private int scoreCol;
    private int percentCol;
    private int classCol;
    private int tagCol;
    private int faiAmaCol;
    private int clubCol;
    private int stateCol;
    private int teamCol;
    private int prelimScoresCol = -1;
    private int flyoffScoresCol = -1;
    private NumberFormat scoreFormatter = NumberFormat.getNumberInstance();
    private NumberFormat scoreFormatter1000 = NumberFormat.getNumberInstance();
    private NumberFormat percentFormatter = NumberFormat.getPercentInstance();
    private NumberFormat percentFormatter100 = NumberFormat.getPercentInstance();
    private JPopupMenu popupMenu;
    private HashMap<Integer, Integer> rowToPositionMap = null;
    private HashMap<Integer, Competitor> rowToPilotMap = null;
    private TotalScoresRenderer totalsTableCellRenderer;

    public TotalScoresPane(Competition competition) {
        this.competition = competition;
        this.configurePanel();
        this.createTable(new TotalScoresTableModel());
        this.table.setAutoResizeMode(0);
        this.setMultilineTableHeaders();
        JScrollPane scrollPane = new JScrollPane(this.table);
        scrollPane.setHorizontalScrollBarPolicy(32);
        this.setLayout(new GridBagLayout());
        this.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.excelAdapter.setPasteEnabled(false);
        this.scoreFormatter1000.setMaximumFractionDigits(0);
        this.percentFormatter.setMaximumFractionDigits(2);
        this.percentFormatter.setMinimumFractionDigits(2);
        this.percentFormatter100.setMaximumFractionDigits(1);
        this.percentFormatter100.setMinimumFractionDigits(1);
        this.addLastColumnAutoResizer();
    }

    private void configurePanel() {
        boolean prelimsCarryOver = this.competition.isFlyoffCompetition() && this.competition.getMainCompetition().getPrelimsCarryOver();
        int nRounds = this.competition.getNumberOfRounds();
        int nCol = nRounds + 12;
        this.useSecondNameColumn = false;
        if (nRounds > 20) {
            nCol += 2;
            this.useSecondNameColumn = true;
        }
        if (prelimsCarryOver) {
            nCol += 2;
        }
        this.colNames = new String[nCol];
        this.colWidths = new int[nCol];
        this.colNames[0] = "";
        this.colWidths[0] = 25;
        this.colNames[1] = "Name";
        this.colWidths[1] = 140;
        int col = 2;
        if (prelimsCarryOver) {
            this.colNames[col] = "Prelims\nScore";
            this.colWidths[col] = 55;
            this.prelimScoresCol = col++;
        }
        this.firstRoundCol = col;
        this.lastRoundCol = this.competition.getNumberOfRounds() + this.firstRoundCol - 1;
        int roundIndex = 0;
        while (roundIndex < this.competition.getNumberOfRounds()) {
            String shortTaskName = this.competition.getRoundTask(roundIndex).getShortName();
            if (shortTaskName == null || shortTaskName.length() == 0) {
                this.colNames[col] = "" + (roundIndex + 1);
                this.colWidths[col] = 40;
            } else {
                this.colNames[col] = String.format("%d\n%s", roundIndex + 1, shortTaskName);
                this.colWidths[col] = 50;
            }
            ++col;
            ++roundIndex;
        }
        this.secondNameCol = -1;
        if (this.useSecondNameColumn) {
            this.colNames[col] = "";
            this.colWidths[col] = 25;
            this.secondNameCol = ++col;
            this.colNames[col] = "Name";
            this.colWidths[col] = 150;
            ++col;
        }
        this.penaltyCol = col;
        this.colNames[col] = "Penalty\n& Rnd";
        this.colWidths[col] = 60;
        ++col;
        if (prelimsCarryOver) {
            this.flyoffScoresCol = col;
            this.colNames[col] = "Flyoffs\nScore";
            this.colWidths[col] = 55;
            ++col;
        }
        this.scoreCol = col;
        this.colNames[col] = "Total\nScore";
        this.colWidths[col] = 55;
        this.percentCol = ++col;
        this.colNames[col] = "%";
        this.colWidths[col] = 55;
        this.classCol = ++col;
        this.colNames[col] = "Class";
        this.colWidths[col] = 60;
        this.tagCol = ++col;
        this.colNames[col] = "Tag";
        this.colWidths[col] = 35;
        this.faiAmaCol = ++col;
        this.colNames[col] = "FAI / AMA\nnumber";
        this.colWidths[col] = 55;
        this.clubCol = ++col;
        this.colNames[col] = "Club";
        this.colWidths[col] = 50;
        this.stateCol = ++col;
        this.colNames[col] = "State";
        this.colWidths[col] = 50;
        this.teamCol = ++col;
        this.colNames[col] = "Team";
        this.colWidths[col] = 65;
        this.colNames[++col] = "";
        this.colWidths[col] = 2;
        int numDigits = this.competition.scoreRoundOffNumDigits();
        this.scoreFormatter.setMinimumFractionDigits(numDigits);
        this.scoreFormatter.setMaximumFractionDigits(numDigits);
    }

    private void loadPilotData() {
        this.rowToPilotMap = new HashMap();
        this.rowToPositionMap = new HashMap();
        int position = 1;
        int row = 0;
        Competitor prevPilot = null;
        int i = 0;
        while (i < this.competition.getCompetitorCount()) {
            Competitor pilot = this.competition.getCompetitorAtPosition(i);
            if (prevPilot != null && prevPilot.getDivision() < pilot.getDivision()) {
                this.rowToPositionMap.put(row, 0);
                this.rowToPilotMap.put(row, null);
                position = 1;
                ++row;
            }
            this.rowToPositionMap.put(row, position);
            this.rowToPilotMap.put(row, pilot);
            prevPilot = pilot;
            ++i;
            ++position;
            ++row;
        }
    }

    private HashMap<Integer, Integer> rowToPositionMap() {
        if (this.rowToPositionMap == null) {
            this.loadPilotData();
        }
        return this.rowToPositionMap;
    }

    private HashMap<Integer, Competitor> rowToPilotMap() {
        if (this.rowToPilotMap == null) {
            this.loadPilotData();
        }
        return this.rowToPilotMap;
    }

    private void configureColumnWidths() {
        int i = 0;
        while (i < this.colWidths.length) {
            this.table.getColumnModel().getColumn(i).setMinWidth(this.colWidths[i]);
            this.table.getColumnModel().getColumn(i).setPreferredWidth(this.colWidths[i]);
            ++i;
        }
    }

    @Override
    protected JPopupMenu getPopupMenu(MouseEvent e) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenuItem copyMenuItem = new JMenuItem(new AbstractAction("Copy"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TotalScoresPane.this.excelAdapter.copyAction();
                }
            });
            copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            this.popupMenu.add(copyMenuItem);
        }
        return this.popupMenu;
    }

    protected double getTotalScore(Competitor pilot) {
        return pilot.calculateTotalScore();
    }

    protected double getPrelimsScore(Competitor pilot) {
        if (this.competition.isFlyoffCompetition()) {
            int index = this.competition.getMainCompetition().getCompetitorList().indexOf(pilot);
            Competitor prelimPilot = this.competition.getMainCompetition().getCompetitorList().get(index);
            return prelimPilot.calculateTotalScore();
        }
        return 0.0;
    }

    protected double getFlyoffsScore(Competitor pilot) {
        if (this.competition.isFlyoffCompetition()) {
            boolean carryOver = this.competition.getMainCompetition().getPrelimsCarryOver();
            this.competition.getMainCompetition().setPrelimsCarryOver(false);
            double score = pilot.calculateTotalScore();
            this.competition.getMainCompetition().setPrelimsCarryOver(carryOver);
            return score;
        }
        return 0.0;
    }

    protected double getPercent(Competitor pilot) {
        return pilot.getPercent();
    }

    @Override
    protected TableCellRenderer getCustomCellRenderer(int row, int column) {
        if (this.totalsTableCellRenderer == null) {
            this.totalsTableCellRenderer = new TotalScoresRenderer();
        }
        return this.totalsTableCellRenderer;
    }

    private class TotalScoresRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        private Font strikeoutFont = null;
        private Font plainFont = new Font("Dialog", 0, 12);

        public TotalScoresRenderer() {
            super.setFont(this.plainFont);
            Hashtable<TextAttribute, Boolean> map = new Hashtable<TextAttribute, Boolean>();
            map.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            this.strikeoutFont = this.plainFont.deriveFont(map);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text;
            if (value == null) {
                value = "";
            }
            if ((text = value.toString()).startsWith("(") && text.endsWith(")")) {
                text = text.substring(1, text.length() - 1);
                super.setFont(this.strikeoutFont);
            } else {
                super.setFont(this.plainFont);
            }
            super.setText(text);
            return this;
        }
    }

    private class TotalScoresTableModel
    extends AbstractTableModel {
        private TotalScoresTableModel() {
        }

        @Override
        public void fireTableStructureChanged() {
            TotalScoresPane.this.rowToPilotMap = null;
            TotalScoresPane.this.rowToPositionMap = null;
            TotalScoresPane.this.configurePanel();
            super.fireTableStructureChanged();
            TotalScoresPane.this.configureColumnWidths();
            TotalScoresPane.this.setMultilineTableHeaders();
            TotalScoresPane.this.resizeLastColumnWidth();
        }

        @Override
        public void fireTableDataChanged() {
            int numDigits = TotalScoresPane.this.competition.scoreRoundOffNumDigits();
            TotalScoresPane.this.scoreFormatter.setMinimumFractionDigits(numDigits);
            TotalScoresPane.this.scoreFormatter.setMaximumFractionDigits(numDigits);
            super.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return TotalScoresPane.this.colNames.length;
        }

        @Override
        public int getRowCount() {
            return TotalScoresPane.this.rowToPositionMap().size();
        }

        @Override
        public String getColumnName(int col) {
            return TotalScoresPane.this.colNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            boolean prelimsCarryOver;
            Competitor pilot = (Competitor)TotalScoresPane.this.rowToPilotMap().get(row);
            if (pilot == null) {
                return "";
            }
            if (col >= TotalScoresPane.this.colNames.length - 1) {
                return "";
            }
            boolean bl = prelimsCarryOver = TotalScoresPane.this.competition.isFlyoffCompetition() && TotalScoresPane.this.competition.getMainCompetition().getPrelimsCarryOver();
            if (col == 0 || col == TotalScoresPane.this.secondNameCol - 1) {
                return "" + TotalScoresPane.this.rowToPositionMap().get(row);
            }
            if (col == 1 || col == TotalScoresPane.this.secondNameCol) {
                return pilot.getFullName();
            }
            if (prelimsCarryOver && col == TotalScoresPane.this.prelimScoresCol) {
                double score = TotalScoresPane.this.getPrelimsScore(pilot);
                if (score != 0.0) {
                    return TotalScoresPane.this.scoreFormatter.format(score);
                }
                return "";
            }
            if (col >= TotalScoresPane.this.firstRoundCol && col <= TotalScoresPane.this.lastRoundCol) {
                int round = col - TotalScoresPane.this.firstRoundCol;
                double roundScore = pilot.getRoundScore(round);
                String displayValue = roundScore == 1000.0 ? TotalScoresPane.this.scoreFormatter1000.format(roundScore) : (roundScore <= 0.0 ? "" : TotalScoresPane.this.scoreFormatter.format(roundScore));
                if (pilot.isDiscardRound(round) && pilot.calculateTotalScore() >= 0.0) {
                    return "(" + displayValue + ")";
                }
                return displayValue;
            }
            if (col == TotalScoresPane.this.penaltyCol) {
                int penalty = pilot.getPenalty();
                if (penalty == 0) {
                    return "";
                }
                StringBuffer res = new StringBuffer();
                res.append(pilot.getPenalty());
                if (pilot.getPenaltyRounds().length() > 0) {
                    res.append("/").append(pilot.getPenaltyRounds());
                }
                return res.toString();
            }
            if (prelimsCarryOver && col == TotalScoresPane.this.flyoffScoresCol) {
                double score = TotalScoresPane.this.getFlyoffsScore(pilot);
                if (score != 0.0) {
                    return TotalScoresPane.this.scoreFormatter.format(score);
                }
                return "";
            }
            if (col == TotalScoresPane.this.scoreCol) {
                double score = TotalScoresPane.this.getTotalScore(pilot);
                if (score != 0.0) {
                    return TotalScoresPane.this.scoreFormatter.format(score);
                }
                return "";
            }
            if (col == TotalScoresPane.this.percentCol) {
                double val = TotalScoresPane.this.getPercent(pilot);
                if (val == 100.0) {
                    return TotalScoresPane.this.percentFormatter100.format(1.0);
                }
                if (val != 0.0) {
                    return TotalScoresPane.this.percentFormatter.format(TotalScoresPane.this.getPercent(pilot) / 100.0);
                }
                return "";
            }
            if (col == TotalScoresPane.this.classCol) {
                String val = pilot.getProperty("Class");
                return val == null ? "" : val;
            }
            if (col == TotalScoresPane.this.tagCol) {
                String val = pilot.getProperty("Tag");
                return val == null ? "" : val;
            }
            if (col == TotalScoresPane.this.faiAmaCol) {
                String val = pilot.getProperty("FAI/AMA Num");
                return val == null ? "" : val;
            }
            if (col == TotalScoresPane.this.clubCol) {
                String val = pilot.getProperty("Club");
                return val == null ? "" : val;
            }
            if (col == TotalScoresPane.this.stateCol) {
                String val = pilot.getProperty("State");
                return val == null ? "" : val;
            }
            if (col == TotalScoresPane.this.teamCol) {
                String val = pilot.getProperty("Team");
                return val == null ? "" : val;
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

