/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.Competition;
import f3kscore.Competitor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Team
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Competitor> pilots = new ArrayList<Competitor>();
    private final String name;
    private final Competition competition;

    public Team(String name, Competition competition) {
        this.name = name;
        this.competition = competition;
    }

    public String getName() {
        return this.name;
    }

    public void addPilot(Competitor pilot) {
        this.pilots.add(pilot);
    }

    public void removePilot(Competitor pilot) {
        this.pilots.remove(pilot);
        if (this.pilots.size() == 0) {
            this.competition.removeTeam(this.name);
        }
    }

    public double getTeamScore() {
        double teamScore = 0.0;
        for (Competitor pilot : this.pilots) {
            teamScore += pilot.calculateTotalScore();
        }
        return teamScore;
    }

    public List<Competitor> getPilotList() {
        return this.pilots;
    }
}

