/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.CompetitionTask;
import f3kscore.F3KScore;
import f3kscore.F3KScoreConstants;
import f3kscore.StdTask;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class TasksPane
extends AbstractF3KScoreEditorPanel
implements F3KScoreConstants {
    private JTextField txtNumRounds;
    private JTextField txtNumFlyoffRounds;
    private JCheckBox chkboxScoresCarryover = new JCheckBox("Preliminary scores carry over to fly-offs");
    private String EMPTY_ITEM = "  ";
    private JPopupMenu popupMenu;
    private JMenuItem copyMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem moveUpMenuItem;
    private JMenuItem moveDownMenuItem;
    private TaskTableRenderer taskNumberRenderer;
    private TaskTableRenderer taskDescriptionRenderer;

    public TasksPane(Competition competition) {
        this.competition = competition;
        this.createTable(new TasksTableModel());
        this.table.setAutoResizeMode(3);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add(scrollPane);
        JLabel lbl = new JLabel("Number of contest rounds:");
        this.txtNumRounds = new JTextField();
        this.txtNumRounds.setMinimumSize(new Dimension(50, 20));
        this.txtNumRounds.setPreferredSize(new Dimension(50, 20));
        this.txtNumRounds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasksPane.this.txtNumRounds.transferFocus();
            }
        });
        this.txtNumRounds.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TasksPane.this.numberOfRoundsChanged();
            }
        });
        JLabel lbl2 = new JLabel("Number of fly-off rounds:");
        this.txtNumFlyoffRounds = new JTextField();
        this.txtNumFlyoffRounds.setMinimumSize(new Dimension(50, 20));
        this.txtNumFlyoffRounds.setPreferredSize(new Dimension(50, 20));
        this.txtNumFlyoffRounds.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasksPane.this.txtNumFlyoffRounds.transferFocus();
            }
        });
        this.txtNumFlyoffRounds.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                TasksPane.this.numberOfFlyoffRoundsChanged();
                if (TasksPane.this.txtNumFlyoffRounds.getText().length() > 0) {
                    TasksPane.this.chkboxScoresCarryover.setEnabled(true);
                } else {
                    TasksPane.this.chkboxScoresCarryover.setSelected(false);
                    TasksPane.this.chkboxScoresCarryover.setEnabled(false);
                }
            }
        });
        this.chkboxScoresCarryover.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TasksPane.this.competition.setPrelimsCarryOver(TasksPane.this.chkboxScoresCarryover.isSelected());
                TasksPane.this.competition.setResultsDirty();
            }
        });
        JButton btnUp = new JButton(new ImageIcon(F3KScore.class.getResource("arrow_up.png")));
        JButton btnDown = new JButton(new ImageIcon(F3KScore.class.getResource("arrow_down.png")));
        JButton btnDelete = new JButton(new ImageIcon(F3KScore.class.getResource("delete_icon.png")));
        btnUp.setMargin(new Insets(2, 2, 2, 2));
        btnDown.setMargin(new Insets(2, 2, 2, 2));
        btnDelete.setMargin(new Insets(2, 2, 2, 2));
        btnUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasksPane.this.moveUp();
            }
        });
        btnDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasksPane.this.moveDown();
            }
        });
        btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TasksPane.this.deleteTask();
            }
        });
        this.configurePanel();
        this.excelAdapter.setPasteEnabled(false);
        this.setLayout(new GridBagLayout());
        super.add((Component)lbl, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 5), 0, 0));
        super.add((Component)this.txtNumRounds, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 10, 0), 0, 0));
        super.add((Component)lbl2, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 50, 10, 5), 0, 0));
        super.add((Component)this.txtNumFlyoffRounds, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 10, 0), 0, 0));
        super.add((Component)this.chkboxScoresCarryover, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 10, 0), 0, 0));
        super.add((Component)scrollPane, new GridBagConstraints(1, 1, 5, 4, 1.0, 1.0, 10, 1, new Insets(0, 0, 10, 10), 0, 0));
        super.add((Component)btnUp, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 3, 3, 3), 0, 0));
        super.add((Component)btnDown, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 3, 3), 0, 0));
        super.add((Component)btnDelete, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    private void moveUp() {
        int[] selRows = this.table.getSelectedRows();
        if (selRows.length == 0 || selRows[0] <= 0) {
            this.table.clearSelection();
            return;
        }
        int nRounds = this.competition.getNumberOfRounds();
        this.table.setRowSelectionInterval(selRows[0], selRows[selRows.length - 1]);
        int i = 0;
        while (i < selRows.length) {
            int row = selRows[i];
            boolean isFlyoffRow = row + 1 > nRounds;
            boolean isOneAboveFlyoffRow = row > nRounds;
            CompetitionTask selectedTask = null;
            CompetitionTask nextUpTask = null;
            selectedTask = isFlyoffRow ? this.competition.getFlyoffCompetition().getRoundTask(row - nRounds) : this.competition.getRoundTask(row);
            if (isOneAboveFlyoffRow) {
                nextUpTask = this.competition.getFlyoffCompetition().getRoundTask(row - 1 - nRounds);
                this.competition.getFlyoffCompetition().setRoundTask(row - 1 - nRounds, selectedTask);
            } else {
                nextUpTask = this.competition.getRoundTask(row - 1);
                this.competition.setRoundTask(row - 1, selectedTask);
            }
            if (isFlyoffRow) {
                this.competition.getFlyoffCompetition().setRoundTask(row - nRounds, nextUpTask);
            } else {
                this.competition.setRoundTask(row, nextUpTask);
            }
            ++i;
        }
        this.competition.setResultsDirty();
        this.competition.setChangesMade(true);
        this.table.setRowSelectionInterval(selRows[0] - 1, selRows[selRows.length - 1] - 1);
    }

    private void moveDown() {
        int[] selRows = this.table.getSelectedRows();
        if (selRows.length == 0 || selRows[selRows.length - 1] >= this.table.getModel().getRowCount() - 1) {
            this.table.clearSelection();
            return;
        }
        int nRounds = this.competition.getNumberOfRounds();
        this.table.setRowSelectionInterval(selRows[0], selRows[selRows.length - 1]);
        int i = selRows.length - 1;
        while (i >= 0) {
            int row = selRows[i];
            boolean isFlyoffRow = row + 1 > nRounds;
            boolean isOneDownFlyoffRow = row + 2 > nRounds;
            CompetitionTask selectedTask = null;
            CompetitionTask nextDownTask = null;
            selectedTask = isFlyoffRow ? this.competition.getFlyoffCompetition().getRoundTask(row - nRounds) : this.competition.getRoundTask(row);
            if (isOneDownFlyoffRow) {
                nextDownTask = this.competition.getFlyoffCompetition().getRoundTask(row + 1 - nRounds);
                this.competition.getFlyoffCompetition().setRoundTask(row + 1 - nRounds, selectedTask);
            } else {
                nextDownTask = this.competition.getRoundTask(row + 1);
                this.competition.setRoundTask(row + 1, selectedTask);
            }
            if (isFlyoffRow) {
                this.competition.getFlyoffCompetition().setRoundTask(row - nRounds, nextDownTask);
            } else {
                this.competition.setRoundTask(row, nextDownTask);
            }
            --i;
        }
        this.competition.setResultsDirty();
        this.competition.setChangesMade(true);
        this.table.setRowSelectionInterval(selRows[0] + 1, selRows[selRows.length - 1] + 1);
    }

    private void deleteTask() {
        int[] selRows = this.table.getSelectedRows();
        if (selRows.length == 0 || selRows[0] < 0) {
            this.table.clearSelection();
            return;
        }
        int nRounds = this.competition.getNumberOfRounds();
        int i = selRows.length - 1;
        while (i >= 0) {
            boolean isFlyoffRow;
            int row = selRows[i];
            boolean bl = isFlyoffRow = row + 1 > nRounds;
            if (isFlyoffRow) {
                int nFlyoffROunds = this.competition.getFlyoffCompetition().getNumberOfRounds();
                if (nFlyoffROunds == 1) {
                    this.competition.setFlyoffCompetition(null);
                    this.competition.fireChangeEvent();
                    return;
                }
                this.competition.getFlyoffCompetition().removeTask(row - nRounds);
            } else {
                if (nRounds == 1) {
                    return;
                }
                this.competition.removeTask(row);
            }
            --i;
        }
        this.competition.setResultsDirty();
        this.competition.setChangesMade(true);
    }

    @Override
    public AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    public void configurePanel() {
        this.txtNumRounds.setText("" + this.competition.getNumberOfRounds());
        if (this.competition.getFlyoffCompetition() != null) {
            this.txtNumFlyoffRounds.setText("" + this.competition.getFlyoffCompetition().getNumberOfRounds());
            this.chkboxScoresCarryover.setEnabled(true);
            this.chkboxScoresCarryover.setSelected(this.competition.getPrelimsCarryOver());
        } else {
            this.chkboxScoresCarryover.setEnabled(false);
            this.chkboxScoresCarryover.setSelected(false);
            this.txtNumFlyoffRounds.setText("");
        }
        CompetitionTask[] taskList = null;
        switch (this.competition.getEventType()) {
            case 2: 
            case 3: {
                taskList = new CompetitionTask[]{StdTask.ALES_TD_6, StdTask.ALES_TD_8, StdTask.ALES_TD_10, StdTask.ALES_TD_15};
                break;
            }
            case 4: {
                taskList = new CompetitionTask[]{StdTask.F5J_10, StdTask.F5J_15};
                break;
            }
            case 5: {
                taskList = new CompetitionTask[]{StdTask.F3J_10, StdTask.F3J_15};
                break;
            }
            case 1: {
                taskList = new CompetitionTask[]{StdTask.F3K_A, StdTask.F3K_A2, StdTask.F3K_B, StdTask.F3K_B2, StdTask.F3K_C, StdTask.F3K_C2, StdTask.F3K_C3, StdTask.F3K_D, StdTask.F3K_E, StdTask.F3K_E2, StdTask.F3K_F, StdTask.F3K_G, StdTask.F3K_H, StdTask.F3K_I, StdTask.F3K_J, StdTask.F3K_K, StdTask.F3K_L, StdTask.F3K_M, StdTask.F3K_N, StdTask.F3K_DEUCE_1, StdTask.F3K_DEUCE_2, StdTask.F3K_LADDER, StdTask.F3K_TWO_FLIGHTS, StdTask.F3K_1x10};
                break;
            }
            default: {
                taskList = StdTask.values();
            }
        }
        JComboBox<StdTask> comboBox = new JComboBox<StdTask>(taskList);
        comboBox.setMaximumRowCount(18);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension screen = toolkit.getScreenSize();
        if (screen.height < 699) {
            comboBox.setMaximumRowCount(10);
        }
        this.table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(comboBox));
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(0).setMinWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(1).setMinWidth(200);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(2000);
        PopupMenuListener actionListener = new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent evt) {
                if (TasksPane.this.table.isEditing()) {
                    TasksPane.this.table.getCellEditor().stopCellEditing();
                    TasksPane.this.table.removeEditor();
                    TasksPane.this.table.clearSelection();
                }
            }
        };
        comboBox.addPopupMenuListener(actionListener);
        this.table.setSelectionMode(0);
    }

    @Override
    public void dataChanged() {
        super.dataChanged();
        if (this.competition.getFlyoffCompetition() != null) {
            this.chkboxScoresCarryover.setSelected(this.competition.getPrelimsCarryOver());
        }
    }

    private void numberOfRoundsChanged() {
        int val = -1;
        try {
            val = Integer.parseInt(this.txtNumRounds.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (val < 1 || val > 50) {
            String badVal = this.txtNumRounds.getText();
            this.txtNumRounds.setText("" + this.competition.getNumberOfRounds());
            JOptionPane.showMessageDialog(this, String.format("Invalid value entered for number of rounds: \"%s\"\nMust be an integer between 1 and 50.", badVal), "Invalid entry", 0);
            return;
        }
        if (val == this.competition.getNumberOfRounds()) {
            return;
        }
        this.competition.setSelectedRoundIndex(0);
        this.competition.setNumberOfRounds(val);
        this.competition.setChangesMade(true);
    }

    private void numberOfFlyoffRoundsChanged() {
        int val = -1;
        if (this.txtNumFlyoffRounds.getText().trim().length() == 0) {
            val = 0;
            if (this.competition.getFlyoffCompetition() == null) {
                return;
            }
        } else {
            try {
                val = Integer.parseInt(this.txtNumFlyoffRounds.getText());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (val < 0 || val > 10) {
            String badVal = this.txtNumFlyoffRounds.getText();
            JOptionPane.showMessageDialog(this, String.format("Invalid value entered for number of  fly-off rounds: \"%s\"\nMust be an integer between 0 and 10.", badVal), "Invalid entry", 0);
            if (this.competition.getFlyoffCompetition() == null) {
                this.txtNumFlyoffRounds.setText("");
            } else {
                this.txtNumFlyoffRounds.setText("" + this.competition.getFlyoffCompetition().getNumberOfRounds());
            }
            return;
        }
        if (val == 0 && this.competition.getFlyoffCompetition() != null) {
            int reply = JOptionPane.showConfirmDialog(this, "Do you want to remove all fly-off rounds?", "Remove fly-off rounds?", 0);
            if (reply == 0) {
                this.competition.setFlyoffCompetition(null);
                this.competition.fireChangeEvent();
                return;
            }
            this.txtNumFlyoffRounds.setText("" + this.competition.getFlyoffCompetition().getNumberOfRounds());
            return;
        }
        if (this.competition.getFlyoffCompetition() == null) {
            this.competition.createFlyoffCompetition(val);
        } else if (this.competition.getFlyoffCompetition().getNumberOfRounds() != val) {
            this.competition.getFlyoffCompetition().setNumberOfRounds(val);
        }
    }

    @Override
    protected JPopupMenu getPopupMenu(MouseEvent e) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.deleteMenuItem = new JMenuItem(new AbstractAction("Delete"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TasksPane.this.deleteTask();
                }
            });
            this.popupMenu.add(this.deleteMenuItem);
            this.copyMenuItem = new JMenuItem(new AbstractAction("Copy"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TasksPane.this.excelAdapter.copyAction();
                }
            });
            this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            this.popupMenu.add(this.copyMenuItem);
            this.moveUpMenuItem = new JMenuItem(new AbstractAction("Move Up"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TasksPane.this.moveUp();
                }
            });
            this.popupMenu.add(this.moveUpMenuItem);
            this.moveDownMenuItem = new JMenuItem(new AbstractAction("Move Down"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    TasksPane.this.moveDown();
                }
            });
            this.popupMenu.add(this.moveDownMenuItem);
        }
        return this.popupMenu;
    }

    @Override
    protected TableCellRenderer getCustomCellRenderer(int row, int column) {
        if (column == 0) {
            if (this.taskNumberRenderer == null) {
                this.taskNumberRenderer = new TaskTableRenderer(0);
            }
            return this.taskNumberRenderer;
        }
        if (this.taskDescriptionRenderer == null) {
            this.taskDescriptionRenderer = new TaskTableRenderer(2);
        }
        return this.taskDescriptionRenderer;
    }

    private class TaskTableRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        public TaskTableRenderer(int alignment) {
            Font plainFont = new Font("Dialog", 0, 12);
            super.setFont(plainFont);
            super.setHorizontalAlignment(alignment);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                value = "";
            }
            String text = value.toString();
            super.setText(text);
            if (isSelected) {
                super.setBackground(table.getSelectionBackground());
            } else {
                super.setBackground(table.getBackground());
            }
            return this;
        }
    }

    private class TasksTableModel
    extends AbstractTableModel {
        private TasksTableModel() {
        }

        @Override
        public void fireTableStructureChanged() {
            super.fireTableStructureChanged();
            TasksPane.this.configurePanel();
        }

        @Override
        public int getRowCount() {
            int nRounds = TasksPane.this.competition.getNumberOfRounds();
            if (TasksPane.this.competition.getFlyoffCompetition() != null) {
                nRounds += TasksPane.this.competition.getFlyoffCompetition().getNumberOfRounds();
            }
            return nRounds;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return "Round";
            }
            if (col == 1) {
                return "Task";
            }
            return "Description";
        }

        @Override
        public Object getValueAt(int row, int col) {
            boolean flyoffRow;
            int nRounds = TasksPane.this.competition.getNumberOfRounds();
            boolean bl = flyoffRow = row + 1 > nRounds;
            if (col == 0) {
                if (!flyoffRow) {
                    return String.valueOf(row + 1);
                }
                return String.format("Flyoff-%d", row + 1 - nRounds);
            }
            if (col == 1) {
                if (!flyoffRow) {
                    return TasksPane.this.competition.getRoundTask(row).getName();
                }
                return TasksPane.this.competition.getFlyoffCompetition().getRoundTask(row - nRounds).getName();
            }
            if (!flyoffRow) {
                return TasksPane.this.competition.getRoundTask(row).getDescription();
            }
            return TasksPane.this.competition.getFlyoffCompetition().getRoundTask(row - nRounds).getDescription();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            boolean flyoffRow;
            if (TasksPane.this.EMPTY_ITEM.equals(value)) {
                return;
            }
            int nRounds = TasksPane.this.competition.getNumberOfRounds();
            boolean bl = flyoffRow = row + 1 > nRounds;
            if (!flyoffRow) {
                TasksPane.this.competition.setRoundTask(row, (CompetitionTask)value);
            } else {
                TasksPane.this.competition.getFlyoffCompetition().setRoundTask(row - nRounds, (CompetitionTask)value);
                TasksPane.this.competition.getFlyoffCompetition().setResultsDirty();
                TasksPane.this.competition.getFlyoffCompetition().setChangesMade(true);
            }
            TasksPane.this.competition.setResultsDirty();
            TasksPane.this.competition.setChangesMade(true);
        }
    }
}

