/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.Competitor;
import f3kscore.CompetitorGroup;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;

public class StartListPane
extends AbstractF3KScoreEditorPanel {
    private static final int roundHeaderRows = 2;
    private static final int groupHeaderRows = 3;
    private static final int numColumns = 4;
    private List<List<String>> tableData;
    private JPopupMenu popupMenu;
    private int groupsSortOrder = 1;

    public StartListPane(Competition competition) {
        this.competition = competition;
        this.createTable(new StartListTableModel());
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.setLayout(new GridBagLayout());
        super.add((Component)scrollPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        this.configureTableData();
        this.excelAdapter.setPasteEnabled(false);
    }

    @Override
    public AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    private void configureTableData() {
        this.tableData = new ArrayList<List<String>>();
        int roundIndex = 0;
        while (roundIndex < this.competition.getNumberOfRounds()) {
            this.tableData.add(null);
            ArrayList<String> rowData = new ArrayList<String>();
            rowData.add(String.format("_ Round %s - %s", roundIndex + 1, this.competition.getRoundTask(roundIndex).getDescription()));
            this.tableData.add(rowData);
            int nGroups = this.competition.getGroupCount(roundIndex);
            int groupNumber = 1;
            while (groupNumber <= nGroups) {
                ArrayList<CompetitorGroup> groupBatch = new ArrayList<CompetitorGroup>();
                int maxGroupSizeInBatch = 0;
                int i = 0;
                while (i < 4 && groupNumber <= nGroups) {
                    groupBatch.add(new CompetitorGroup(this.competition, groupNumber++, roundIndex, this.groupsSortOrder));
                    if (((CompetitorGroup)groupBatch.get(i)).getCompetitorCount() > maxGroupSizeInBatch) {
                        maxGroupSizeInBatch = ((CompetitorGroup)groupBatch.get(i)).getCompetitorCount();
                    }
                    ++i;
                }
                this.tableData.add(null);
                rowData = new ArrayList();
                for (CompetitorGroup aGroup : groupBatch) {
                    rowData.add(String.format("_______ Group %s _______", aGroup.getGroupName()));
                }
                this.tableData.add(rowData);
                int pilotIndex = 0;
                while (pilotIndex < maxGroupSizeInBatch) {
                    rowData = new ArrayList();
                    for (CompetitorGroup aGroup : groupBatch) {
                        Competitor pilot = aGroup.getCompetitor(pilotIndex);
                        rowData.add(pilot == null ? null : pilot.getFullName());
                    }
                    this.tableData.add(rowData);
                    ++pilotIndex;
                }
            }
            ++roundIndex;
        }
    }

    public void sortGroups(int sortOrder) {
        this.groupsSortOrder = sortOrder;
        this.tableModel.fireTableStructureChanged();
    }

    @Override
    protected JPopupMenu getPopupMenu(MouseEvent e) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            JMenuItem copyMenuItem = new JMenuItem(new AbstractAction("Copy"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    StartListPane.this.excelAdapter.copyAction();
                }
            });
            copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            this.popupMenu.add(copyMenuItem);
        }
        return this.popupMenu;
    }

    private class StartListTableModel
    extends AbstractTableModel {
        private StartListTableModel() {
        }

        @Override
        public void fireTableStructureChanged() {
            StartListPane.this.configureTableData();
            super.fireTableStructureChanged();
        }

        @Override
        public void fireTableDataChanged() {
            StartListPane.this.configureTableData();
            super.fireTableDataChanged();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return StartListPane.this.tableData.size();
        }

        @Override
        public String getColumnName(int col) {
            return "";
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (StartListPane.this.tableData.get(row) == null) {
                return null;
            }
            if (((List)StartListPane.this.tableData.get(row)).size() <= col) {
                return null;
            }
            return ((List)StartListPane.this.tableData.get(row)).get(col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object obj, int i, int j) {
        }
    }
}

