/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.Competition;
import f3kscore.CompetitionTask;
import f3kscore.Competitor;
import f3kscore.CompetitorGroup;
import f3kscore.PrintUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class RoundScoresPane
extends AbstractF3KScoreEditorPanel {
    protected JLabel taskSelectLabel = new JLabel("Round:");
    private JSpinner taskSelectSpinner;
    private JLabel taskDescription;
    protected JPanel topPanel = new JPanel();
    protected JScrollPane scrollPane;
    protected int clickedCol;
    private JPopupMenu popupMenu;
    private JMenuItem menuItemMovePilotsToGroup;
    private JMenuItem menuItemAddPilotsToReflight;
    private JMenuItem menuItemRemovePilotsFromReflight;
    private JMenuItem menuItemRegroupPilotsSeeded;
    private JMenu menuPrintCards;
    private JMenuItem copyMenuItem;
    private JMenuItem pasteMenuItem;
    private int NAME_COL = 0;
    private int nColumns;
    private int SUM_COL;
    private int SCORE_COL;
    private int PENALTY_COL;
    private int LAUNCH_PENALTY_COL = -1;
    private int LAUNCH_ALTITUDE_COL = -1;
    private int LANDING_POINTS_COL = -1;
    protected NumberFormat scoreFormatter = new DecimalFormat("0.000");
    protected NumberFormat scoreFormatter1000 = new DecimalFormat("0,000");
    protected NumberFormat launchPenaltyFormatter = new DecimalFormat("0.0");
    private int groupsSortOrder = 0;
    private TableCellRenderer groupDividerRenderer = null;
    private boolean doNotShowTruncatedTimeDialog = false;

    public RoundScoresPane(Competition competition) {
        this.competition = competition;
        Font font = new Font("serif", 1, 18);
        this.taskSelectSpinner = new JSpinner();
        this.taskSelectSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RoundScoresPane.this.roundChanged();
            }
        });
        this.taskSelectLabel.setFont(font);
        this.taskDescription = new JLabel();
        this.taskDescription.setFont(font);
        this.createTable(new RoundScoresTableModel());
        this.table.setColumnSelectionAllowed(true);
        this.table.setAutoResizeMode(0);
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.tableModel.fireTableStructureChanged();
        this.table.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "DELETE_SCORES");
        this.table.getActionMap().put("DELETE_SCORES", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RoundScoresPane.this.deleteSelectedScores();
            }
        });
        this.topPanel.setLayout(new GridBagLayout());
        this.topPanel.add((Component)this.taskSelectLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 10, 0), 0, 0));
        this.topPanel.add((Component)this.taskSelectSpinner, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 10, 10), 0, 0));
        this.topPanel.add((Component)this.taskDescription, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 10, 10), 0, 0));
        this.topPanel.add((Component)new JLabel(""), new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setLayout(new GridBagLayout());
        this.add((Component)this.topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 3, 3, 3), 0, 0));
        this.table.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "ENTER_PRESSED");
        this.table.getActionMap().put("ENTER_PRESSED", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RoundScoresPane.this.clickedCol > 0) {
                    int selRow = RoundScoresPane.this.table.getSelectedRow();
                    int selCol = RoundScoresPane.this.table.getSelectedColumn();
                    if (selRow < 0 || selCol < 0) {
                        return;
                    }
                    if (RoundScoresPane.this.clickedCol != -1 && selCol < RoundScoresPane.this.clickedCol) {
                        RoundScoresPane.this.clickedCol = selCol;
                    }
                    if (RoundScoresPane.this.table.isEditing()) {
                        RoundScoresPane.this.table.getCellEditor().stopCellEditing();
                        RoundScoresPane.this.table.removeEditor();
                    }
                    if (++selRow < RoundScoresPane.this.table.getRowCount()) {
                        RoundScoresPane.this.table.setRowSelectionInterval(selRow, selRow);
                        RoundScoresPane.this.table.setColumnSelectionInterval(RoundScoresPane.this.clickedCol, RoundScoresPane.this.clickedCol);
                        RoundScoresPane.this.table.editCellAt(selRow, RoundScoresPane.this.clickedCol);
                    } else {
                        RoundScoresPane.this.clickedCol = -1;
                    }
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    RoundScoresPane.this.clickedCol = RoundScoresPane.this.table.columnAtPoint(e.getPoint());
                }
            }
        });
        this.addLastColumnAutoResizer();
    }

    protected void deleteSelectedScores() {
        int[] rows = this.table.getSelectedRows();
        if (rows.length == 0) {
            return;
        }
        int[] cols = this.table.getSelectedColumns();
        int i = 0;
        while (i < rows.length) {
            int j = 0;
            while (j < cols.length) {
                int row = rows[i];
                int col = cols[j];
                if (this.tableModel.isCellEditable(row, col)) {
                    this.tableModel.setValueAt("", row, col);
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    protected JPopupMenu getPopupMenu(MouseEvent e) {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.copyMenuItem = new JMenuItem(new AbstractAction("Copy"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.excelAdapter.copyAction();
                }
            });
            this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
            this.popupMenu.add(this.copyMenuItem);
            this.pasteMenuItem = new JMenuItem(new AbstractAction("Paste"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.excelAdapter.pasteAction();
                }
            });
            this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
            this.popupMenu.add(this.pasteMenuItem);
            this.menuItemMovePilotsToGroup = new JMenuItem(new AbstractAction("Move selected pilots to another group"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.showMovePilotsToAnotherGroupDlg();
                }
            });
            if (!this.competition.isFlyoffCompetition()) {
                this.popupMenu.add(this.menuItemMovePilotsToGroup);
            }
            this.menuItemAddPilotsToReflight = new JMenuItem(new AbstractAction("Add selected pilots to the re-flight group"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.includeSelectedPilotsToReflightGroup(true);
                }
            });
            this.popupMenu.add(this.menuItemAddPilotsToReflight);
            this.menuItemRemovePilotsFromReflight = new JMenuItem(new AbstractAction("Remove selected pilots from the re-flight group"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.includeSelectedPilotsToReflightGroup(false);
                }
            });
            this.popupMenu.add(this.menuItemRemovePilotsFromReflight);
            this.menuItemRegroupPilotsSeeded = new JMenuItem(new AbstractAction("Re-generate flight groups for this round..."){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.regenerateGroupsDlg();
                }
            });
            if (!this.competition.isFlyoffCompetition()) {
                this.popupMenu.add(this.menuItemRegroupPilotsSeeded);
            }
            JMenu printMenu = new JMenu("Print");
            this.popupMenu.add(printMenu);
            this.menuPrintCards = new JMenu("Score cards for selected pilot(s)");
            printMenu.add(this.menuPrintCards);
            JMenu printAllRoundCardsMenu = new JMenu("All rounds");
            this.menuPrintCards.add(printAllRoundCardsMenu);
            printAllRoundCardsMenu.add(new JMenuItem(new AbstractAction("8 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.printSelectedPilotsAllScoreCards(8);
                }
            }));
            printAllRoundCardsMenu.add(new JMenuItem(new AbstractAction("6 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.printSelectedPilotsAllScoreCards(6);
                }
            }));
            printAllRoundCardsMenu.add(new JMenuItem(new AbstractAction("4 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.printSelectedPilotsAllScoreCards(4);
                }
            }));
            printAllRoundCardsMenu.add(new JMenuItem(new AbstractAction("2 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.printSelectedPilotsAllScoreCards(2);
                }
            }));
            JMenu printSelectedGroupCardsMenu = new JMenu("Displayed round only");
            this.menuPrintCards.add(printSelectedGroupCardsMenu);
            printSelectedGroupCardsMenu.add(new JMenuItem(new AbstractAction("8 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.printSelectedPilotsScoreCards(8);
                }
            }));
            printSelectedGroupCardsMenu.add(new JMenuItem(new AbstractAction("6 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.printSelectedPilotsScoreCards(6);
                }
            }));
            printSelectedGroupCardsMenu.add(new JMenuItem(new AbstractAction("4 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.printSelectedPilotsScoreCards(4);
                }
            }));
            printSelectedGroupCardsMenu.add(new JMenuItem(new AbstractAction("2 cards per page"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    RoundScoresPane.this.printSelectedPilotsScoreCards(2);
                }
            }));
            if (!this.competition.isFlyoffCompetition()) {
                printMenu.add(new JMenuItem(new AbstractAction("Start list (groups) for this round"){

                    @Override
                    public void actionPerformed(ActionEvent arg0) {
                        PrintUtils.printStartList(RoundScoresPane.this.competition.getSelectedRoundIndex() + 1);
                    }
                }));
            }
            printMenu.add(new JMenuItem(new AbstractAction("Score keeper entry sheet for this round"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PrintUtils.printScoreKeeperEntrySheet(RoundScoresPane.this.competition, RoundScoresPane.this);
                }
            }));
            printMenu.add(new JMenuItem(new AbstractAction("Scores for this round"){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PrintUtils.printSelectedRoundScores(RoundScoresPane.this.competition, RoundScoresPane.this);
                }
            }));
        }
        boolean pilotsSelected = this.getSelectedPilotList().size() > 0;
        int rowNumber = this.table.rowAtPoint(e.getPoint());
        boolean clickedInReflightGroup = ((RoundScoresTableModel)this.tableModel).groupNumberForRow(rowNumber) < 0;
        boolean roundFlown = this.competition.getSelectedRoundIndex() < this.competition.getDoneRoundCount();
        this.menuItemMovePilotsToGroup.setEnabled(pilotsSelected && !clickedInReflightGroup);
        this.menuItemAddPilotsToReflight.setEnabled(pilotsSelected && !clickedInReflightGroup && roundFlown);
        this.menuItemRemovePilotsFromReflight.setEnabled(pilotsSelected && clickedInReflightGroup);
        this.menuPrintCards.setEnabled(pilotsSelected);
        this.pasteMenuItem.setEnabled(Toolkit.getDefaultToolkit().getSystemClipboard().getContents(this) != null);
        this.menuItemRegroupPilotsSeeded.setEnabled(!roundFlown);
        return this.popupMenu;
    }

    protected void includeSelectedPilotsToReflightGroup(boolean include) {
        ArrayList<Competitor> selPilots = this.getSelectedPilotList();
        if (selPilots.size() == 0) {
            return;
        }
        int roundIndex = this.competition.getSelectedRoundIndex();
        for (Competitor pilot : selPilots) {
            pilot.includeInReflightGroup(roundIndex, include);
        }
        this.tableModel.fireTableStructureChanged();
    }

    private ArrayList<Competitor> getSelectedPilotList() {
        ArrayList<Competitor> pilots = new ArrayList<Competitor>();
        int[] selRows = this.table.getSelectedRows();
        if (selRows.length == 0) {
            return pilots;
        }
        int i = 0;
        while (i < selRows.length) {
            int row = selRows[i];
            Competitor pilot = ((RoundScoresTableModel)this.tableModel).rowToPilotMap().get(row);
            if (pilot != null) {
                pilots.add(pilot);
            }
            ++i;
        }
        return pilots;
    }

    private void showMovePilotsToAnotherGroupDlg() {
        ArrayList<Competitor> selPilots = this.getSelectedPilotList();
        if (selPilots.size() == 0) {
            return;
        }
        JPanel panel = new JPanel();
        String msg = "Enter new group (A,B,C,...):  ";
        if (!this.competition.useLetterGroupNames()) {
            msg = "Enter new group (1,2,3,...):  ";
        }
        JLabel lbl = new JLabel(msg);
        JTextField txtField = new JTextField();
        txtField.setColumns(4);
        panel.add(lbl);
        panel.add(txtField);
        int reply = JOptionPane.showConfirmDialog(this, panel, "Move selected pilot(s) to a new group", 2, -1);
        if (reply != 0) {
            return;
        }
        String txt = txtField.getText().trim();
        if (txt.length() == 0) {
            return;
        }
        int groupNumber = -1;
        if (this.competition.useLetterGroupNames() && (groupNumber = Competition.groupLetterToNumber(txt)) <= 0) {
            JOptionPane.showMessageDialog(this, "Invalid entry for group name.\nPlease enter one of A,B,C,D,E,F,G,H,I,J", "Invalid entry", 0);
            return;
        }
        try {
            groupNumber = Integer.parseInt(txt);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (groupNumber < 1 || groupNumber > 10) {
            JOptionPane.showMessageDialog(this, "Invalid entry for group number.\nPlease enter one of 1,2,3,4,5,6,7,8,9,10", "Invalid entry", 0);
            return;
        }
        int roundIndex = this.competition.getSelectedRoundIndex();
        for (Competitor pilot : selPilots) {
            pilot.setGroupNum(roundIndex, groupNumber);
        }
        this.competition.setChangesMade(true);
        this.competition.fireChangeEvent();
    }

    private void printSelectedPilotsAllScoreCards(int nCardsPerPage) {
        ArrayList<Competitor> selPilots = this.getSelectedPilotList();
        if (selPilots.size() == 0) {
            return;
        }
        PrintUtils.printScoreCardsSelectedPilot(selPilots, nCardsPerPage, this.competition);
    }

    private void printSelectedPilotsScoreCards(int nCardsPerPage) {
        ArrayList<Competitor> pilots = new ArrayList<Competitor>();
        ArrayList<Integer> groupList = new ArrayList<Integer>();
        int[] selRows = this.table.getSelectedRows();
        if (selRows.length == 0) {
            return;
        }
        int i = 0;
        while (i < selRows.length) {
            int row = selRows[i];
            Competitor pilot = ((RoundScoresTableModel)this.tableModel).rowToPilotMap().get(row);
            if (pilot != null) {
                pilots.add(pilot);
                groupList.add(((RoundScoresTableModel)this.tableModel).groupNumberForRow(row));
            }
            ++i;
        }
        PrintUtils.printScoreCardsSelectedPilotTaskGroup(pilots, this.competition, groupList, nCardsPerPage);
    }

    private void regenerateGroupsDlg() {
        JPanel mainPanel = new JPanel(new GridBagLayout());
        JPanel panel = new JPanel(new GridBagLayout());
        String msg = "Enter number of groups:  ";
        JLabel lbl = new JLabel(msg);
        JTextField txtNumGroups = new JTextField();
        txtNumGroups.setText(String.valueOf(this.competition.getMaxGroupCount()));
        txtNumGroups.setColumns(4);
        panel.add(lbl);
        panel.add(txtNumGroups);
        int row = 0;
        mainPanel.add((Component)panel, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        JRadioButton radioRandomGroups = new JRadioButton("Random pilot assignment");
        final JRadioButton radioSortedGroupsDecreasing = new JRadioButton("Sort by the total scores, best at the top");
        JRadioButton radioSortedGroupsIncreasing = new JRadioButton("Sort by the total scores, best at the bottom");
        ButtonGroup group2 = new ButtonGroup();
        group2.add(radioRandomGroups);
        group2.add(radioSortedGroupsDecreasing);
        group2.add(radioSortedGroupsIncreasing);
        radioRandomGroups.setSelected(false);
        radioSortedGroupsDecreasing.setSelected(false);
        radioSortedGroupsIncreasing.setSelected(true);
        mainPanel.add((Component)radioRandomGroups, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        mainPanel.add((Component)radioSortedGroupsDecreasing, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        mainPanel.add((Component)radioSortedGroupsIncreasing, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 20, 5), 0, 0));
        int reply = JOptionPane.showConfirmDialog(this, mainPanel, "Re-generate flight groups for this round", 2, -1);
        if (reply != 0) {
            return;
        }
        if (txtNumGroups.getText().trim().length() == 0) {
            return;
        }
        int numGroups = -1;
        try {
            numGroups = Integer.parseInt(txtNumGroups.getText().trim());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (numGroups < 1 || numGroups > 20) {
            JOptionPane.showMessageDialog(this, String.format("Invalid entry for the number of groups: \"%s\"\nEnter an integer in the range 1...%d", txtNumGroups.getText(), 20), "Invalid Entry", 0);
            txtNumGroups.setText(String.valueOf(this.competition.getMaxGroupCount()));
            return;
        }
        if (numGroups > this.competition.getCompetitorCount()) {
            JOptionPane.showMessageDialog(this, String.format("Number of groups cannot be above the number of pilots! (%s > %d)", txtNumGroups.getText(), this.competition.getCompetitorCount()), "Invalid Entry", 0);
            txtNumGroups.setText(String.valueOf(this.competition.getMaxGroupCount()));
            return;
        }
        int pilotCount = this.competition.getCompetitorCount();
        ArrayList<Competitor> pilots = new ArrayList<Competitor>(this.competition.getCompetitorList());
        int selectedRoundIndex = this.competition.getSelectedRoundIndex();
        if (numGroups == 1) {
            int c = 0;
            while (c < pilotCount) {
                this.competition.getCompetitor(c).setGroupNum(selectedRoundIndex, 1);
                ++c;
            }
        } else if (radioRandomGroups.isSelected()) {
            ArrayList<Integer> groups = new ArrayList<Integer>();
            int i = 1;
            while (i <= numGroups) {
                groups.add(i);
                ++i;
            }
            Collections.shuffle(groups);
            Collections.shuffle(pilots);
            i = 0;
            int j = 0;
            while (i < pilots.size()) {
                ((Competitor)pilots.get(i)).setGroupNum(selectedRoundIndex, (Integer)groups.get(j++));
                if (j >= numGroups) {
                    j = 0;
                }
                ++i;
            }
        } else {
            if (this.competition.getDoneRoundCount() == 0) {
                JOptionPane.showMessageDialog(this, String.format("No rounds have been completed. Total scores cannot be used for generating groups.", new Object[0]), "Invalid Selection", 0);
                return;
            }
            Collections.sort(pilots, new Comparator<Competitor>(){

                @Override
                public int compare(Competitor o1, Competitor o2) {
                    if (radioSortedGroupsDecreasing.isSelected()) {
                        if (o1.calculateTotalScore() > o2.calculateTotalScore()) {
                            return -1;
                        }
                        if (o1.calculateTotalScore() < o2.calculateTotalScore()) {
                            return 1;
                        }
                        return 0;
                    }
                    if (o1.calculateTotalScore() < o2.calculateTotalScore()) {
                        return -1;
                    }
                    if (o1.calculateTotalScore() > o2.calculateTotalScore()) {
                        return 1;
                    }
                    return 0;
                }
            });
            int pilotIndex = 0;
            int group = 1;
            while (group <= numGroups) {
                int groupSize = (pilotCount - pilotIndex) / (numGroups - group + 1);
                if (group == numGroups) {
                    groupSize = pilotCount - pilotIndex;
                }
                int i = 0;
                while (i < groupSize) {
                    ((Competitor)pilots.get(pilotIndex++)).setGroupNum(selectedRoundIndex, group);
                    ++i;
                }
                ++group;
            }
        }
        this.competition.setChangesMade(true);
        this.competition.fireChangeEvent();
    }

    @Override
    public AbstractTableModel getTableModel() {
        return this.tableModel;
    }

    private void configurePanel() {
        this.taskSelectSpinner.setModel(new SpinnerNumberModel(this.competition.getSelectedRoundIndex() + 1, 1, this.competition.getNumberOfRounds(), 1));
        this.taskDescription.setText(this.competition.getSelectedTask().getDescription());
        this.table.getColumnModel().getColumn(0).setMinWidth(200);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        int i = 1;
        while (i <= this.tableModel.getColumnCount() - 2) {
            this.table.getColumnModel().getColumn(i).setMinWidth(72);
            this.table.getColumnModel().getColumn(i).setPreferredWidth(72);
            ++i;
        }
        this.setMultilineTableHeaders();
        this.resizeLastColumnWidth();
    }

    public void roundChanged() {
        this.stopEditing();
        String params = this.taskSelectSpinner.getValue().toString();
        int tcount = Integer.parseInt(params);
        this.competition.setSelectedRoundIndex(tcount - 1);
        this.tableModel.fireTableStructureChanged();
        this.scrollPane.getViewport().setViewPosition(new Point(0, 0));
    }

    public void selectRound(int roundIndex) {
        this.taskSelectSpinner.getModel().setValue(roundIndex + 1);
        this.roundChanged();
    }

    @Override
    protected TableCellRenderer getCustomCellRenderer(int row, int column) {
        Competitor pilot = ((RoundScoresTableModel)this.tableModel).rowToPilotMap().get(row);
        if (pilot == null) {
            if (this.groupDividerRenderer == null) {
                this.groupDividerRenderer = new GroupDividerRenderer();
            }
            return this.groupDividerRenderer;
        }
        return null;
    }

    private String convertSecondsToMinSec(double totalTime, String format) {
        double secs = totalTime % 60.0;
        DecimalFormat formatter = new DecimalFormat("00");
        if (format != null) {
            formatter = new DecimalFormat(format);
        } else if (this.competition.getSelectedTask().isF3Jtask() || this.competition.getSelectedTask().isF3Ktask()) {
            formatter = new DecimalFormat("00.0");
        }
        int mins = (int)(totalTime - secs) / 60;
        return String.valueOf(mins) + ":" + formatter.format(secs);
    }

    private double convertScoreToSeconds(String valString) {
        int tensOfSecond = -1;
        int dotPos = -1;
        char decimalSep = new DecimalFormat().getDecimalFormatSymbols().getDecimalSeparator();
        if ((this.competition.getSelectedTask().isF3Jtask() || this.competition.getSelectedTask().isF3Ktask()) && (dotPos = valString.lastIndexOf(decimalSep)) != -1) {
            if (dotPos == valString.length() - 1) {
                tensOfSecond = 0;
            } else {
                String tensOfSecString = valString.substring(dotPos + 1, dotPos + 2);
                tensOfSecond = Integer.parseInt(tensOfSecString);
            }
            valString = valString.substring(0, dotPos);
        }
        double time = -1.0;
        dotPos = valString.indexOf(46);
        if (dotPos == -1) {
            dotPos = valString.indexOf(58);
        }
        if (dotPos == -1) {
            dotPos = valString.indexOf(44);
        }
        if (dotPos == -1) {
            dotPos = valString.indexOf(59);
        }
        if (dotPos == -1) {
            dotPos = valString.indexOf(32);
        }
        if (dotPos == -1) {
            time = Integer.parseInt(valString);
        } else {
            String secString = valString.substring(dotPos + 1);
            String minString = valString.substring(0, dotPos);
            int seconds = Integer.parseInt(secString);
            if (seconds >= 60) {
                JOptionPane.showMessageDialog(this, "Invalid value: number of seconds must not exceed 59.", "Invalid Entry", 0);
                return -1.0;
            }
            time = Integer.parseInt(minString) * 60 + Integer.parseInt(secString);
        }
        if (tensOfSecond != -1) {
            time += (double)tensOfSecond * 0.1;
        }
        return time;
    }

    public void sortGroups(int sortOrder) {
        this.groupsSortOrder = sortOrder;
        this.getTableModel().fireTableStructureChanged();
    }

    private class GroupDividerRenderer
    extends JLabel
    implements TableCellRenderer {
        public GroupDividerRenderer() {
            Font plainFont = new Font("Dialog", 0, 12);
            super.setFont(plainFont);
            super.setForeground(Color.DARK_GRAY);
            super.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                value = "";
            }
            String text = value.toString();
            super.setText(text);
            return this;
        }
    }

    private class RoundScoresTableModel
    extends AbstractTableModel {
        private HashMap<Integer, Competitor> rowToPilotMap;
        private ArrayList<Integer> groupNumberList;

        private RoundScoresTableModel() {
        }

        @Override
        public void fireTableStructureChanged() {
            CompetitionTask task = RoundScoresPane.this.competition.getSelectedTask();
            int nFlights = task.getNumFlights();
            RoundScoresPane.this.nColumns = nFlights + 5;
            RoundScoresPane.this.SUM_COL = nFlights + 1;
            RoundScoresPane.this.SCORE_COL = nFlights + 2;
            RoundScoresPane.this.PENALTY_COL = nFlights + 3;
            RoundScoresPane.this.LAUNCH_PENALTY_COL = -1;
            RoundScoresPane.this.LAUNCH_ALTITUDE_COL = -1;
            RoundScoresPane.this.LANDING_POINTS_COL = -1;
            if (task.isF5Jtask()) {
                RoundScoresPane.this.LANDING_POINTS_COL = 2;
                RoundScoresPane.this.LAUNCH_ALTITUDE_COL = 3;
                RoundScoresPane.this.LAUNCH_PENALTY_COL = 6;
                RoundScoresPane roundScoresPane = RoundScoresPane.this;
                roundScoresPane.SUM_COL = roundScoresPane.SUM_COL + 1;
                RoundScoresPane roundScoresPane2 = RoundScoresPane.this;
                roundScoresPane2.SCORE_COL = roundScoresPane2.SCORE_COL + 1;
                RoundScoresPane roundScoresPane3 = RoundScoresPane.this;
                roundScoresPane3.PENALTY_COL = roundScoresPane3.PENALTY_COL + 1;
                RoundScoresPane roundScoresPane4 = RoundScoresPane.this;
                roundScoresPane4.nColumns = roundScoresPane4.nColumns + 1;
            } else if (task.isAlesTdTask()) {
                RoundScoresPane roundScoresPane = RoundScoresPane.this;
                roundScoresPane.nColumns = roundScoresPane.nColumns - 2;
                RoundScoresPane.this.LANDING_POINTS_COL = RoundScoresPane.this.SUM_COL - 1;
                RoundScoresPane.this.SUM_COL = -1;
                RoundScoresPane roundScoresPane5 = RoundScoresPane.this;
                roundScoresPane5.SCORE_COL = roundScoresPane5.SCORE_COL - 1;
                RoundScoresPane.this.PENALTY_COL = -1;
            } else if (task.isF3Jtask()) {
                RoundScoresPane.this.LANDING_POINTS_COL = 2;
            }
            this.rowToPilotMap = null;
            this.groupNumberList = null;
            super.fireTableStructureChanged();
            RoundScoresPane.this.configurePanel();
        }

        @Override
        public void fireTableDataChanged() {
            super.fireTableDataChanged();
        }

        public HashMap<Integer, Competitor> rowToPilotMap() {
            if (this.rowToPilotMap == null) {
                this.loadTableData();
            }
            return this.rowToPilotMap;
        }

        public int groupNumberForRow(int rowIndex) {
            if (this.groupNumberList == null) {
                this.loadTableData();
            }
            if (rowIndex >= this.groupNumberList.size()) {
                return 0;
            }
            return this.groupNumberList.get(rowIndex);
        }

        private void loadTableData() {
            this.rowToPilotMap = new HashMap();
            this.groupNumberList = new ArrayList();
            int nRows = this.getRowCount();
            int group = 1;
            int rowIndex = 0;
            int roundIndex = RoundScoresPane.this.competition.getSelectedRoundIndex();
            int nGroups = RoundScoresPane.this.competition.getGroupCount(roundIndex, true);
            boolean hasReflight = new CompetitorGroup(RoundScoresPane.this.competition, -1, roundIndex, false).getCompetitorCount() > 0;
            while (rowIndex < nRows) {
                CompetitorGroup compGroup = new CompetitorGroup(RoundScoresPane.this.competition, group, roundIndex, RoundScoresPane.this.groupsSortOrder);
                this.groupNumberList.add(group);
                ++rowIndex;
                int groupSize = compGroup.getCompetitorCount();
                int i = 0;
                while (i < groupSize) {
                    this.rowToPilotMap.put(rowIndex, compGroup.getCompetitor(i));
                    this.groupNumberList.add(group);
                    ++rowIndex;
                    ++i;
                }
                if (!hasReflight || ++group < nGroups) continue;
                group = -1;
            }
            RoundScoresPane.this.groupsSortOrder = 0;
        }

        private String formatGroupName(int groupNumber) {
            if (groupNumber > 0) {
                return String.format("########    Group-%s   ########", RoundScoresPane.this.competition.formatGroupNumberAsString(groupNumber));
            }
            return String.format("#######   Re-flight group  ######", RoundScoresPane.this.competition.formatGroupNumberAsString(groupNumber));
        }

        @Override
        public int getColumnCount() {
            return RoundScoresPane.this.nColumns;
        }

        @Override
        public int getRowCount() {
            if (RoundScoresPane.this.competition.getCompetitorCount() == 0) {
                return 0;
            }
            int roundIndex = RoundScoresPane.this.competition.getSelectedRoundIndex();
            return RoundScoresPane.this.competition.getCompetitorCount() + RoundScoresPane.this.competition.getGroupCount(roundIndex, true) + new CompetitorGroup(RoundScoresPane.this.competition, -1, roundIndex, false).getCompetitorCount();
        }

        @Override
        public String getColumnName(int col) {
            if (col == RoundScoresPane.this.NAME_COL) {
                return "Name";
            }
            if (col >= RoundScoresPane.this.nColumns - 1) {
                return "";
            }
            if (col == RoundScoresPane.this.SUM_COL) {
                if (RoundScoresPane.this.competition.getSelectedTask().isF5Jtask() || RoundScoresPane.this.competition.getSelectedTask().isF3Jtask()) {
                    return "Total\nPoints";
                }
                return "Total\nTime";
            }
            if (col == RoundScoresPane.this.LAUNCH_PENALTY_COL) {
                return "Launch\nPenalty";
            }
            if (col == RoundScoresPane.this.SCORE_COL) {
                return "Norm\nScore";
            }
            if (col == RoundScoresPane.this.PENALTY_COL) {
                return "Penalty";
            }
            int timeCut = RoundScoresPane.this.competition.getSelectedTask().getMaxTimeCut(col - 1);
            String[] flightTimesColumnTitles = RoundScoresPane.this.competition.getSelectedTask().getFlightTimesColumnTitles();
            if (flightTimesColumnTitles != null) {
                return flightTimesColumnTitles[col - 1];
            }
            if (timeCut <= 0) {
                return String.format("T-%d", col);
            }
            if (RoundScoresPane.this.competition.isUseSecondsForFlightTimes()) {
                return String.format("T-%d\nMax %d", col, timeCut);
            }
            return String.format("T-%d\nMax %s", col, RoundScoresPane.this.convertSecondsToMinSec(timeCut, "00"));
        }

        @Override
        public Class<?> getColumnClass(int colIndex) {
            if (colIndex > RoundScoresPane.this.NAME_COL && colIndex < RoundScoresPane.this.SUM_COL) {
                CompetitionTask task = RoundScoresPane.this.competition.getSelectedTask();
                int flightIndex = colIndex - 1;
                int maxTime = task.getMaxTimeCut(flightIndex);
                int minTime = task.getMinTimeCut(flightIndex);
                if (maxTime > 0 && maxTime == minTime) {
                    return Boolean.class;
                }
            }
            return super.getColumnClass(colIndex);
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (col >= RoundScoresPane.this.nColumns - 1) {
                return "";
            }
            int nFlights = RoundScoresPane.this.competition.getSelectedTask().getNumFlights();
            int roundIndex = RoundScoresPane.this.competition.getSelectedRoundIndex();
            Competitor pilot = this.rowToPilotMap().get(row);
            boolean isReflightRow = this.groupNumberForRow(row) < 0;
            boolean isSpeedTask = RoundScoresPane.this.competition.getSelectedTask().isSpeedTask();
            boolean isF3JTask = RoundScoresPane.this.competition.getSelectedTask().isF3Jtask();
            boolean isF5JTask = RoundScoresPane.this.competition.getSelectedTask().isF5Jtask();
            boolean isF3KTask = RoundScoresPane.this.competition.getSelectedTask().isF3Ktask();
            if (pilot != null) {
                if (col == RoundScoresPane.this.NAME_COL) {
                    return pilot.getFullName();
                }
                if (col == RoundScoresPane.this.SUM_COL) {
                    double totalTaskSum = pilot.getTaskTotalTime(roundIndex);
                    if (isReflightRow) {
                        totalTaskSum = pilot.getReflightTotalTime(roundIndex);
                    }
                    if (totalTaskSum >= 0.0) {
                        String format = "00";
                        if (isF5JTask || isF3JTask || isF3KTask) {
                            format = "00.0";
                        } else if (isSpeedTask) {
                            format = "00.00";
                        }
                        if (isF3KTask && !RoundScoresPane.this.competition.isUseSecondsForFlightTimes()) {
                            return RoundScoresPane.this.convertSecondsToMinSec(totalTaskSum, format);
                        }
                        DecimalFormat formatter = new DecimalFormat(format);
                        return formatter.format(totalTaskSum);
                    }
                    return "";
                }
                if (col == RoundScoresPane.this.LAUNCH_PENALTY_COL) {
                    double launchPenalty = pilot.getTaskLaunchPenalty(roundIndex);
                    if (isReflightRow) {
                        launchPenalty = pilot.getReflightLaunchPenalty(roundIndex);
                    }
                    if (launchPenalty > 0.0) {
                        return RoundScoresPane.this.launchPenaltyFormatter.format(-1.0 * launchPenalty);
                    }
                    return "";
                }
                if (col == RoundScoresPane.this.SCORE_COL) {
                    double score = pilot.getScore(roundIndex);
                    if (isReflightRow) {
                        score = pilot.getReflightScore(roundIndex);
                    }
                    if (score == 1000.0) {
                        return RoundScoresPane.this.scoreFormatter1000.format(score);
                    }
                    if (score >= 0.0) {
                        int nDigits = RoundScoresPane.this.competition.scoreRoundOffNumDigits();
                        RoundScoresPane.this.scoreFormatter.setMinimumFractionDigits(nDigits);
                        RoundScoresPane.this.scoreFormatter.setMaximumFractionDigits(nDigits);
                        return RoundScoresPane.this.scoreFormatter.format(score);
                    }
                    return "";
                }
                if (col == RoundScoresPane.this.PENALTY_COL) {
                    int penalty = pilot.getPenalty(roundIndex);
                    if (isReflightRow) {
                        penalty = pilot.getReflightPenalty(roundIndex);
                    }
                    if (penalty > 0) {
                        return String.valueOf(penalty);
                    }
                    return "";
                }
                double flightTime = pilot.getTaskTime(roundIndex, col - 1);
                if (isReflightRow) {
                    flightTime = pilot.getReflightTime(roundIndex, col - 1);
                }
                if (flightTime >= 0.0) {
                    if (this.getColumnClass(col) == Boolean.class) {
                        return true;
                    }
                    if (col == RoundScoresPane.this.LANDING_POINTS_COL) {
                        return Integer.toString((int)flightTime);
                    }
                    if (col == RoundScoresPane.this.LAUNCH_ALTITUDE_COL) {
                        return Integer.toString((int)flightTime);
                    }
                    String format = "00";
                    if (isF3JTask || isF3KTask) {
                        format = "00.0";
                    } else if (isSpeedTask) {
                        format = "00.00";
                    }
                    if (!RoundScoresPane.this.competition.isUseSecondsForFlightTimes()) {
                        return RoundScoresPane.this.convertSecondsToMinSec(flightTime, format);
                    }
                    DecimalFormat formatter = new DecimalFormat(format);
                    return formatter.format(flightTime);
                }
                if (this.getColumnClass(col) == Boolean.class) {
                    return false;
                }
                return "";
            }
            if (col == 0) {
                return this.formatGroupName(this.groupNumberForRow(row));
            }
            return "########";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            Competitor pilot = this.rowToPilotMap().get(row);
            return pilot != null && col != RoundScoresPane.this.SUM_COL && col != RoundScoresPane.this.SCORE_COL && col != RoundScoresPane.this.NAME_COL && col != RoundScoresPane.this.LAUNCH_PENALTY_COL;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            double time;
            int timeIndex;
            int maxTimesCount;
            int windowTime;
            boolean isReflight;
            Competitor pilot;
            int roundIndex;
            block27: {
                if (RoundScoresPane.this.clickedCol != -1 && col < RoundScoresPane.this.clickedCol) {
                    RoundScoresPane.this.clickedCol = col;
                }
                roundIndex = RoundScoresPane.this.competition.getSelectedRoundIndex();
                pilot = this.rowToPilotMap().get(row);
                if (pilot == null) {
                    return;
                }
                boolean bl = isReflight = this.groupNumberForRow(row) < 0;
                if (col == RoundScoresPane.this.PENALTY_COL) {
                    int val = -1;
                    if (value.equals("")) {
                        val = 0;
                    } else {
                        try {
                            val = Integer.parseInt(value.toString());
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (val % 100 != 0) {
                            JOptionPane.showMessageDialog(RoundScoresPane.this, "Invalid value: penalty must be a multiple of 100.", "Invalid Entry", 0);
                            return;
                        }
                    }
                    if (!isReflight) {
                        pilot.setPenalty(roundIndex, val);
                    } else {
                        pilot.setReflightPenalty(roundIndex, val);
                    }
                    this.fireTableDataChanged();
                    RoundScoresPane.this.competition.setResultsDirty();
                    RoundScoresPane.this.competition.setChangesMade(true);
                    RoundScoresPane.this.competition.fireChangeEvent();
                    return;
                }
                windowTime = RoundScoresPane.this.competition.getSelectedTask().getWindowTime();
                maxTimesCount = RoundScoresPane.this.competition.getSelectedTask().getNumFlights();
                timeIndex = col - 1;
                if (timeIndex < 0 || timeIndex >= maxTimesCount) {
                    return;
                }
                boolean isSpeedTask = RoundScoresPane.this.competition.getSelectedTask().isSpeedTask();
                boolean isF5JTask = RoundScoresPane.this.competition.getSelectedTask().isF5Jtask();
                boolean isF3JTask = RoundScoresPane.this.competition.getSelectedTask().isF3Jtask();
                time = 0.0;
                if (value instanceof Boolean) {
                    time = ((Boolean)value).booleanValue() ? 1.0 : -1.0;
                } else {
                    String valString = value.toString().trim();
                    if (valString.length() > 0) {
                        try {
                            if (isSpeedTask) {
                                time = Double.parseDouble(valString);
                            } else if (col == RoundScoresPane.this.LAUNCH_ALTITUDE_COL || col == RoundScoresPane.this.LANDING_POINTS_COL) {
                                time = (int)Double.parseDouble(valString);
                            } else {
                                time = RoundScoresPane.this.convertScoreToSeconds(valString);
                                if (roundIndex == 0 && (isF5JTask || isF3JTask) && windowTime > 0 && time >= (double)windowTime) {
                                    JOptionPane.showMessageDialog(RoundScoresPane.this, "Flight time for \"" + pilot.getFullName() + "\" must be less than the window time (" + RoundScoresPane.this.convertSecondsToMinSec(windowTime, null) + ")", "Invalid Flight Time Entry", 0);
                                    return;
                                }
                            }
                            break block27;
                        }
                        catch (NumberFormatException e) {
                            JOptionPane.showMessageDialog(RoundScoresPane.this, "Invalid entry: \"" + value + "\"", "Invalid Entry", 0);
                            return;
                        }
                    }
                    time = -1.0;
                }
            }
            double sumAllFlights = 0.0;
            sumAllFlights = !isReflight ? Math.max(pilot.getAllFlightsTotalTime(roundIndex), 0.0) - Math.max(pilot.getTaskTime(roundIndex, col - 1), 0.0) + time : Math.max(pilot.getReflightAllFlightsTotalTime(roundIndex), 0.0) - Math.max(pilot.getReflightTime(roundIndex, col - 1), 0.0) + time;
            if (RoundScoresPane.this.competition.getSelectedTask().isF3Ktask() && windowTime > 0 && sumAllFlights >= (double)windowTime) {
                JOptionPane.showMessageDialog(RoundScoresPane.this, "Total time for \"" + pilot.getFullName() + "\" must be less than the window time (" + RoundScoresPane.this.convertSecondsToMinSec(windowTime, "00") + ")", "Invalid Flight Time Entry", 0);
                return;
            }
            if (!isReflight) {
                pilot.setTaskTime(roundIndex, timeIndex, time);
            } else {
                pilot.setReflightTime(roundIndex, timeIndex, time);
            }
            if (RoundScoresPane.this.competition.getSelectedTask().isF3Ktask() && !RoundScoresPane.this.doNotShowTruncatedTimeDialog) {
                double totalTaskSum = Math.max(pilot.getTaskTotalTime(roundIndex), 0.0);
                sumAllFlights = 0.0;
                int i = 0;
                while (i < maxTimesCount) {
                    sumAllFlights += Math.max(pilot.getTaskTime(roundIndex, i), 0.0);
                    ++i;
                }
                if (sumAllFlights > totalTaskSum) {
                    JPanel panel = new JPanel();
                    panel.setLayout(new BoxLayout(panel, 1));
                    JLabel lbl = new JLabel("Total time for pilot \"" + pilot.getFullName() + "\" was truncated to " + RoundScoresPane.this.convertSecondsToMinSec(totalTaskSum, "00") + " according to the F3K rules");
                    JCheckBox aCheckBox = new JCheckBox("Do not show this message again");
                    panel.add(lbl);
                    panel.add(new JLabel());
                    panel.add(aCheckBox);
                    JOptionPane.showMessageDialog(RoundScoresPane.this, panel, "Total Time Truncated", 2);
                    RoundScoresPane.this.doNotShowTruncatedTimeDialog = aCheckBox.isSelected();
                }
            }
            this.fireTableDataChanged();
        }
    }
}

