/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.F3KScore;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PrintPreview
extends JDialog
implements ActionListener,
ChangeListener {
    public static final int PRINT_JOB_SENT = 0;
    public static final int PRINT_JOB_CANCELED = 1;
    public static final int PAGE_SETUP_REQUESTED = 2;
    public static final int PRINT_JOB_FAILED = 3;
    public static final int STATUS_UNKNOWN = 4;
    private static int status = 4;
    private static HashPrintRequestAttributeSet attrs = new HashPrintRequestAttributeSet();
    private static PrinterJob pJob = PrinterJob.getPrinterJob();
    private static PageFormat pFormat = null;
    private JButton btnPrint = new JButton("Print");
    private JButton btnPageSetup = new JButton("Page Setup");
    private JButton btnCancel = new JButton("Close");
    private Printable printableContent = null;
    private Page[] pageArray = null;
    private JSpinner pageSelector = new JSpinner();
    private CardLayout cardLayout = new CardLayout();
    private JPanel panel = new JPanel(this.cardLayout);
    private int nPages = 0;
    private JLabel lblTotalPages = new JLabel();

    public static int displayPrintPreview(Printable printableContent, String jobName, OrientationRequested orientation) {
        status = 4;
        pJob.setJobName(jobName);
        attrs.add(orientation);
        if (pFormat == null) {
            pFormat = pJob.defaultPage(new PageFormat());
            float h = (float)pFormat.getHeight();
            float w = (float)pFormat.getWidth();
            attrs.add(new MediaPrintableArea(0.0f, 0.0f, w / 72.0f, h / 72.0f, 25400));
        }
        pFormat = pJob.getPageFormat(attrs);
        new PrintPreview(printableContent);
        while (status == 2) {
            new PrintPreview(printableContent);
        }
        return status;
    }

    public PrintPreview(Printable printable) {
        super((Window)F3KScore.editor(), "Print Preview", Dialog.ModalityType.APPLICATION_MODAL);
        super.setDefaultCloseOperation(2);
        this.printableContent = printable;
        super.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                status = 1;
            }
        });
        this.createPrintPreview();
    }

    private void createPrintPreview() {
        this.configurePages();
        this.setTopPanel();
        this.getContentPane().add((Component)this.panel, "Center");
        Dimension screenSize = this.getToolkit().getScreenSize();
        this.setSize(screenSize.height - 0, screenSize.height - 50);
        this.setLocationRelativeTo(F3KScore.editor());
        this.setVisible(true);
    }

    private void setTopPanel() {
        FlowLayout fl = new FlowLayout();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel topPanel = new JPanel(gbl);
        JPanel temp = new JPanel(fl);
        JLabel lblPage = new JLabel("Page");
        JLabel lblSpace = new JLabel("            ");
        temp.add(lblPage);
        temp.add(this.pageSelector);
        temp.add(this.lblTotalPages);
        temp.add(lblSpace);
        temp.add(this.btnPageSetup);
        temp.add(this.btnPrint);
        temp.add(this.btnCancel);
        gbc.gridx = 1;
        gbc.gridwidth = 2;
        gbl.setConstraints(temp, gbc);
        topPanel.add(temp);
        this.btnPrint.addActionListener(this);
        this.btnPageSetup.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.pageSelector.addChangeListener(this);
        this.btnPrint.setMnemonic('P');
        this.btnCancel.setMnemonic('C');
        this.btnPageSetup.setMnemonic('S');
        this.getContentPane().add((Component)topPanel, "North");
    }

    @Override
    public void stateChanged(ChangeEvent arg0) {
        String pageNumString = this.pageSelector.getValue().toString();
        this.cardLayout.show(this.panel, pageNumString);
        this.validate();
    }

    private void doPrint() {
        try {
            pJob.getPrintService();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(F3KScore.editor(), "Unable to get Print Service. Verify that Print Service is running on your computer.", "Printing Error", 0);
            status = 3;
            return;
        }
        Pageable pages = new Pageable(){

            @Override
            public int getNumberOfPages() {
                return PrintPreview.this.nPages;
            }

            @Override
            public PageFormat getPageFormat(int x) {
                return pFormat;
            }

            @Override
            public Printable getPrintable(int x) {
                return PrintPreview.this.printableContent;
            }
        };
        try {
            pJob.defaultPage(pFormat);
            pJob.setPageable(pages);
            boolean doPrint = pJob.printDialog();
            if (doPrint) {
                pJob.print(attrs);
                status = 0;
            } else {
                status = 1;
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.toString(), "Error in Printing", 1);
            status = 3;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object o = ae.getSource();
        if (o == this.btnPrint) {
            this.doPrint();
        } else if (o == this.btnPageSetup) {
            PageFormat format = pJob.pageDialog(pFormat);
            if (pFormat == format || format == null) {
                return;
            }
            pFormat = format;
            status = 2;
            this.configurePages();
            this.validate();
        } else if (o == this.btnCancel) {
            if (status == 2) {
                status = 1;
            }
            this.dispose();
        }
    }

    private void configurePages() {
        this.nPages = 0;
        try {
            while (this.printableContent.print(null, pFormat, this.nPages) == 0) {
                ++this.nPages;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = 3;
            return;
        }
        this.pageArray = new Page[this.nPages];
        Dimension size = new Dimension((int)pFormat.getPaper().getWidth(), (int)pFormat.getPaper().getHeight());
        if (pFormat.getOrientation() != 1) {
            size = new Dimension(size.height, size.width);
        }
        this.panel.removeAll();
        int i = 0;
        while (i < this.nPages) {
            this.pageArray[i] = new Page(i, size);
            this.panel.add("" + (i + 1), new JScrollPane(this.pageArray[i]));
            ++i;
        }
        this.pageSelector.setModel(new SpinnerNumberModel(1, 1, this.nPages, 1));
        this.lblTotalPages.setText("of " + this.nPages);
    }

    class Page
    extends JLabel {
        private BufferedImage bi = null;
        private Dimension size = null;

        public Page(int n, Dimension size) {
            this.size = size;
            this.bi = new BufferedImage(size.width, size.height, 1);
            Graphics g = this.bi.getGraphics();
            g.setColor(Color.white);
            g.fillRect(0, 0, size.width, size.height);
            g.setColor(Color.black);
            g.drawRect(0, 0, size.width - 1, size.height - 1);
            try {
                PrintPreview.this.printableContent.print(g, pFormat, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.setIcon(new ImageIcon(this.bi));
            super.setVerticalAlignment(0);
            super.setHorizontalAlignment(0);
        }
    }
}

