/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.AbstractF3KScoreEditorPanel;
import f3kscore.CSVWriter;
import f3kscore.Competition;
import f3kscore.Competitor;
import f3kscore.ExcelSpreadsheetReader;
import f3kscore.ExcelSpreadsheetWriter;
import f3kscore.F3KScoreConstants;
import f3kscore.F3kFileFilter;
import f3kscore.FlyoffRoundScoresPane;
import f3kscore.FlyoffTotalScoresPane;
import f3kscore.GroupsPane;
import f3kscore.MergeResultsUtils;
import f3kscore.PilotsDatabaseUtils;
import f3kscore.PlaylistDialog;
import f3kscore.PrintUtils;
import f3kscore.RegistrationPane;
import f3kscore.RoundScoresPane;
import f3kscore.StartListPane;
import f3kscore.TasksPane;
import f3kscore.TeamScoresPane;
import f3kscore.TotalScoresPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXDatePicker;

public class F3KScore
extends JFrame
implements F3KScoreConstants {
    public static Color veryLightGrey = new Color(230, 230, 230);
    public static Color veryLightBlue = new Color(218, 244, 255);
    public static F3KScore editor;
    private final JMenuBar mainMenuBar = new JMenuBar();
    private JMenu printRoundScoresMenu;
    private JMenu printRoundStartListMenu;
    private JMenu exportRoundScoresSubMenu;
    private JMenu printRoundScoreKeeperEntrySheetsMenu;
    private Competition competition;
    private final ArrayList<AbstractF3KScoreEditorPanel> editorPanels;
    private final AbstractF3KScoreEditorPanel registrationPane;
    private final AbstractF3KScoreEditorPanel tasksPane;
    private final AbstractF3KScoreEditorPanel startListPane;
    private final AbstractF3KScoreEditorPanel matrixPane;
    private final AbstractF3KScoreEditorPanel roundsPane;
    private final AbstractF3KScoreEditorPanel totalsPane;
    private final AbstractF3KScoreEditorPanel teamsPane;
    private AbstractF3KScoreEditorPanel flyoffRoundsPane;
    private AbstractF3KScoreEditorPanel flyoffTotalsPane;
    private final int REGISTRATION_PANE = 0;
    private final int TASKS_PANE = 1;
    private final int STARTLIST_PANE = 2;
    private final int MATRIX_PANE = 3;
    private final int ROUNDS_PANE = 4;
    private final int TOTALS_PANE = 5;
    private final int TEAMS_PANE = 6;
    private final JTabbedPane tabbedPane;
    private File loadedFile;
    private Image f3kIcon;
    private Image f3kLogo;
    private JLabel lblCompName;
    private JTextField txtCompName;
    private JComboBox<String> typeSelector;
    private JXDatePicker compStartDatePicker;
    private JXDatePicker compEndDatePicker;
    private F3kFileFilter f3kFilter;
    private F3kFileFilter csvFilter;
    private F3kFileFilter txtFilter;
    private F3kFileFilter xlsxFilter;
    private File currentDir;
    private PlaylistDialog playlistDialog;
    private AbstractF3KScoreEditorPanel previousPanel;
    private ArrayList<Integer> printTotalColumns;
    private int nDropRounds = -1;
    private int nDropRounds2 = -1;
    private int nRoundOffDigits = -1;
    private ArrayList<Integer> printRegistrationColumns;
    private JMenu printMenu;
    private JMenu printFlyoffTotalScoresMenu;
    private JMenu printFlyoffRoundScoresMenu;
    private JMenu printSelectFlyoffRoundSubMenu;
    private JMenu exportFlyoffRoundScoresMenu;
    private JMenu exportSelectFlyoffRoundSubMenu;
    private JMenu printSelectFlyoffRoundScoreKeeperEntrySheetsMenu;
    private JMenu exportFlyoffTotalScoresMenu;
    private ArrayList<Integer> printFlyoffTotalColumns;
    private JMenu flyoffsPrintMenu;

    public static void main(String[] args) throws IOException {
        String fName = null;
        if (args.length > 0) {
            fName = args[0];
        }
        editor = new F3KScore(fName);
    }

    public static F3KScore editor() {
        return editor;
    }

    public F3KScore(String fName) throws IOException {
        this.setTitle("F3KScore");
        URL imgURL = F3KScore.class.getResource("f3k_logo.png");
        this.f3kIcon = new ImageIcon(imgURL).getImage();
        this.setIconImage(this.f3kIcon);
        imgURL = F3KScore.class.getResource("f3kscore.png");
        this.f3kLogo = new ImageIcon(imgURL).getImage();
        this.lblCompName = new JLabel("Event Name:");
        this.txtCompName = new JTextField();
        this.txtCompName.addKeyListener(new KeyListener(){

            @Override
            public void keyReleased(KeyEvent e) {
                F3KScore.this.competition.setCompetitionName(F3KScore.this.txtCompName.getText().trim());
                F3KScore.this.competition.setChangesMade(true);
                if (F3KScore.this.loadedFile == null) {
                    F3KScore.this.setTitle(String.format("F3KScore: %s", F3KScore.this.competition.getCompetitionName()));
                } else {
                    F3KScore.this.setTitle(String.format("F3KScore: %s (%s)", F3KScore.this.competition.getCompetitionName(), F3KScore.this.loadedFile.getAbsolutePath()));
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        JLabel lblCompType = new JLabel("Event Type:");
        this.typeSelector = new JComboBox<String>(COMP_TYPE_NAMES);
        Accessible child = this.typeSelector.getAccessibleContext().getAccessibleChild(0);
        BasicComboPopup popup = (BasicComboPopup)child;
        JList<Object> list = popup.getList();
        list.setSelectionBackground(list.getBackground());
        this.typeSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedType = F3KScore.this.typeSelector.getSelectedIndex();
                if (selectedType == 0) {
                    if (F3KScore.this.competition.getEventType() != 0) {
                        F3KScore.this.typeSelector.setSelectedIndex(F3KScore.this.competition.getEventType());
                    }
                } else if (F3KScore.this.competition.getEventType() != selectedType && !F3KScore.this.changeCompetitionType(selectedType)) {
                    F3KScore.this.typeSelector.setSelectedIndex(F3KScore.this.competition.getEventType());
                }
            }
        });
        JLabel lblCompDate = new JLabel("Start Date:");
        this.compStartDatePicker = new JXDatePicker();
        this.compStartDatePicker.getEditor().setColumns(9);
        this.compStartDatePicker.getEditor().setEditable(false);
        JLabel lblEndDate = new JLabel("End Date:");
        this.compEndDatePicker = new JXDatePicker();
        this.compEndDatePicker.getEditor().setColumns(9);
        this.compEndDatePicker.getEditor().setEditable(false);
        this.compStartDatePicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date date = F3KScore.this.compStartDatePicker.getDate();
                if (date == null) {
                    return;
                }
                SimpleDateFormat frmt = new SimpleDateFormat("MM-dd-yyyy");
                String dateStr = frmt.format(date);
                F3KScore.this.competition.setDate(dateStr);
                try {
                    if (F3KScore.this.competition.getEndDate() == null || frmt.parse(F3KScore.this.competition.getEndDate()).before(date)) {
                        Calendar c = Calendar.getInstance();
                        c.setTime(date);
                        c.add(5, 1);
                        date = c.getTime();
                        F3KScore.this.compEndDatePicker.setDate(date);
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        this.compEndDatePicker.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date date = F3KScore.this.compEndDatePicker.getDate();
                if (date == null) {
                    return;
                }
                SimpleDateFormat frmt = new SimpleDateFormat("MM-dd-yyyy");
                String dateStr = frmt.format(date);
                F3KScore.this.competition.setEndDate(dateStr);
                try {
                    if (F3KScore.this.competition.getDate() == null || frmt.parse(F3KScore.this.competition.getDate()).after(date)) {
                        Calendar c = Calendar.getInstance();
                        c.setTime(date);
                        c.add(5, -1);
                        date = c.getTime();
                        F3KScore.this.compStartDatePicker.setDate(date);
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        this.createMenuBar();
        this.competition = new Competition(this, 1);
        this.setTitle(String.format("F3KScore: %s", this.competition.getCompetitionName()));
        this.f3kFilter = new F3kFileFilter("f3k", "F3KScore files (.f3k)");
        this.csvFilter = new F3kFileFilter("csv", "Comma separated value files (.csv)");
        this.txtFilter = new F3kFileFilter("txt", "Text files (.txt)");
        this.xlsxFilter = new F3kFileFilter("xlsx", "Excel files (.xlsx)");
        this.editorPanels = new ArrayList();
        this.registrationPane = new RegistrationPane(this.competition);
        this.editorPanels.add(this.registrationPane);
        this.tasksPane = new TasksPane(this.competition);
        this.editorPanels.add(this.tasksPane);
        this.matrixPane = new GroupsPane(this.competition);
        this.editorPanels.add(this.matrixPane);
        this.startListPane = new StartListPane(this.competition);
        this.editorPanels.add(this.startListPane);
        this.roundsPane = new RoundScoresPane(this.competition);
        this.editorPanels.add(this.roundsPane);
        this.totalsPane = new TotalScoresPane(this.competition);
        this.editorPanels.add(this.totalsPane);
        this.teamsPane = new TeamScoresPane(this.competition);
        this.editorPanels.add(this.teamsPane);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addTab("Pilots", this.registrationPane);
        this.tabbedPane.addTab("Tasks", this.tasksPane);
        this.tabbedPane.addTab("Flight Matrix", this.matrixPane);
        this.tabbedPane.addTab("Start List", this.startListPane);
        this.tabbedPane.addTab("Round Scores", this.roundsPane);
        this.tabbedPane.addTab("Total Scores", this.totalsPane);
        this.tabbedPane.addTab("Team Scores", this.teamsPane);
        this.previousPanel = this.registrationPane;
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                if (F3KScore.this.previousPanel != null) {
                    F3KScore.this.previousPanel.stopEditing();
                }
                F3KScore.this.previousPanel = (AbstractF3KScoreEditorPanel)F3KScore.this.editorPanels.get(F3KScore.this.tabbedPane.getSelectedIndex());
                F3KScore.this.previousPanel.updatePanel();
            }
        });
        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.add((Component)lblCompType, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 3, 3), 0, 0));
        contentPane.add(this.typeSelector, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        contentPane.add((Component)this.lblCompName, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 3, 3), 0, 0));
        contentPane.add((Component)this.txtCompName, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        contentPane.add((Component)lblCompDate, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 3, 3), 0, 0));
        contentPane.add((Component)this.compStartDatePicker, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 3), 0, 0));
        contentPane.add((Component)lblEndDate, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 10, 3, 3), 0, 0));
        contentPane.add((Component)this.compEndDatePicker, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(3, 3, 3, 10), 0, 0));
        contentPane.add((Component)this.tabbedPane, new GridBagConstraints(0, 1, 8, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        contentPane.setOpaque(true);
        super.setContentPane(contentPane);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension mySize = new Dimension(1100, 600);
        if (mySize.width > screen.width * 9 / 10) {
            mySize.width = screen.width * 9 / 10;
        }
        if (mySize.height > screen.height * 9 / 10) {
            mySize.height = screen.height * 9 / 10;
        }
        super.setSize(mySize);
        super.setLocationRelativeTo(null);
        super.setVisible(true);
        super.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                F3KScore.this.exitApplication();
            }
        });
        if (fName != null) {
            final File file = new File(fName);
            if (file.getCanonicalFile().isDirectory()) {
                this.currentDir = file;
                this.fireChangeEvent();
                return;
            }
            if (file.exists() && file.canRead()) {
                this.currentDir = file.getParentFile();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            F3KScore.this.loadFromFile(file);
                        }
                        catch (Exception ex) {
                            JOptionPane.showMessageDialog(F3KScore.this, "Failed when trying to read file \"" + file.getName() + "\"\nError message:\n\n\"" + ex.getLocalizedMessage() + "\"", "Error reading data file", 0);
                        }
                    }
                });
            }
        } else {
            this.fireChangeEvent();
        }
    }

    private void exitApplication() {
        if (this.competition.changesMade()) {
            int reply = JOptionPane.showConfirmDialog(this, "You are about to close your data.\nSave changes before closing?", "Save data?", 1);
            if (reply == 0) {
                this.save(this.loadedFile);
            }
            if (reply != 0 && reply != 1) {
                return;
            }
        }
        System.exit(0);
    }

    public Competition getCompetition() {
        return this.competition;
    }

    public AbstractF3KScoreEditorPanel getRegistrationPane() {
        return this.registrationPane;
    }

    public AbstractF3KScoreEditorPanel getTasksPane() {
        return this.tasksPane;
    }

    public AbstractF3KScoreEditorPanel getStartListPane() {
        return this.startListPane;
    }

    public AbstractF3KScoreEditorPanel getGroupsPane() {
        return this.matrixPane;
    }

    public AbstractF3KScoreEditorPanel getRoundScoresPane() {
        return this.roundsPane;
    }

    public AbstractF3KScoreEditorPanel getFlyoffRoundScoresPane() {
        return this.flyoffRoundsPane;
    }

    public AbstractF3KScoreEditorPanel getTotalScoresPane() {
        return this.totalsPane;
    }

    public AbstractF3KScoreEditorPanel getFlyoffTotalScoresPane() {
        return this.flyoffTotalsPane;
    }

    public AbstractF3KScoreEditorPanel getTeamsPane() {
        return this.teamsPane;
    }

    public File getLoadedFile() {
        return this.loadedFile;
    }

    public File getCurrentDir() {
        return this.currentDir;
    }

    public void setCurrentDir(File currentDir) {
        this.currentDir = currentDir;
    }

    private File chooseFileExport(String dlgTitle, String sheetName) {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        fileChooser.setDialogTitle(dlgTitle);
        fileChooser.addChoosableFileFilter(this.txtFilter);
        fileChooser.addChoosableFileFilter(this.csvFilter);
        fileChooser.addChoosableFileFilter(this.xlsxFilter);
        fileChooser.setCurrentDirectory(this.currentDir);
        fileChooser.setSelectedFile(new File(sheetName));
        int returnVal = fileChooser.showDialog(this, "Export");
        if (returnVal == 0) {
            int reply;
            this.currentDir = fileChooser.getCurrentDirectory();
            File file = fileChooser.getSelectedFile();
            String ext = F3kFileFilter.getExtension(file);
            if (!(ext.equalsIgnoreCase("csv") || ext.equalsIgnoreCase("txt") || ext.equalsIgnoreCase("xlsx"))) {
                file = fileChooser.getFileFilter() == this.txtFilter ? new File(String.valueOf(file.getAbsolutePath()) + ".txt") : (fileChooser.getFileFilter() == this.csvFilter ? new File(String.valueOf(file.getAbsolutePath()) + ".csv") : (fileChooser.getFileFilter() == this.xlsxFilter ? new File(String.valueOf(file.getAbsolutePath()) + ".xlsx") : new File(String.valueOf(file.getAbsolutePath()) + ".xlsx")));
            }
            if (file.exists() && (reply = JOptionPane.showConfirmDialog(this, "File \"" + file.getName() + "\" exists.\nDo you want to overwrite it?", "File exists", 0)) != 0) {
                return null;
            }
            return file;
        }
        return null;
    }

    public List<String[]> exportTableData(TableModel tableModel, int maxRows, int nCols, List<Integer> selectedColumns) {
        if (selectedColumns == null) {
            selectedColumns = new ArrayList<Integer>();
            int i = 0;
            while (i < nCols) {
                selectedColumns.add(i);
                ++i;
            }
        } else {
            nCols = selectedColumns.size();
        }
        ArrayList<String[]> data = new ArrayList<String[]>();
        String[] header = new String[nCols];
        int i = 0;
        while (i < nCols) {
            int index = selectedColumns.get(i);
            header[i] = tableModel.getColumnName(index);
            ++i;
        }
        data.add(header);
        maxRows = maxRows < 0 ? tableModel.getRowCount() : maxRows;
        int row = 0;
        while (row < maxRows) {
            String[] line = new String[nCols];
            int col = 0;
            while (col < nCols) {
                int index = selectedColumns.get(col);
                line[col] = tableModel.getValueAt(row, index) == null ? "" : tableModel.getValueAt(row, index).toString();
                ++col;
            }
            data.add(line);
            ++row;
        }
        return data;
    }

    private void exportTable(AbstractF3KScoreEditorPanel tablePanel, File file, String sheetName, int maxRows, int nCols, List<Integer> selectedColumns) {
        block17: {
            if (file == null) {
                return;
            }
            TableModel tableModel = tablePanel.getTableModel();
            List<String[]> data = this.exportTableData(tableModel, maxRows, nCols, selectedColumns);
            String ext = F3kFileFilter.getExtension(file);
            this.setCursor(Cursor.getPredefinedCursor(3));
            CSVWriter writer = null;
            try {
                try {
                    if (ext.equalsIgnoreCase("csv")) {
                        writer = new CSVWriter(new FileWriter(file));
                        writer.writeAll(data);
                        break block17;
                    }
                    if (ext.equalsIgnoreCase("txt")) {
                        writer = new CSVWriter(new FileWriter(file), '\t');
                        writer.writeAll(data);
                        break block17;
                    }
                    if (tablePanel instanceof TotalScoresPane) {
                        ExcelSpreadsheetWriter.writeAll(file, sheetName, data, true, true);
                        break block17;
                    }
                    ExcelSpreadsheetWriter.writeAll(file, sheetName, data, true, false);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(editor, String.format("Failed when writing data to file \"%s\": %n%n%s", file.getName(), e.getLocalizedMessage()), "File write error", 0);
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    public void exportTableToExcelFile(AbstractF3KScoreEditorPanel tablePanel, String sheetName, int maxRows, int nCols, ExcelSpreadsheetWriter xlWriter) throws Exception {
        TableModel tableModel = tablePanel.getTableModel();
        List<String[]> data = this.exportTableData(tableModel, maxRows, nCols, null);
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (tablePanel instanceof TotalScoresPane) {
                xlWriter.writeTotalScores(sheetName, data);
            } else {
                xlWriter.writeAll(sheetName, data);
            }
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void exportPilotList() {
        if (this.competition.getCompetitorCount() == 0) {
            JOptionPane.showMessageDialog(this, "You have no competition pilots.", "No competition data", 0);
            return;
        }
        File file = this.chooseFileExport("Select file name for exporting pilot list", "Pilots");
        this.exportTable(this.registrationPane, file, "Pilots", this.competition.getCompetitorCount(), this.registrationPane.getTableModel().getColumnCount(), null);
    }

    public void exportTaskList() {
        File file = this.chooseFileExport("Select file name for exporting task list", "Tasks");
        this.exportTable(this.tasksPane, file, "Tasks", -1, this.tasksPane.getTableModel().getColumnCount(), null);
    }

    public void exportFlightMatrix() {
        if (this.competition.getCompetitorCount() == 0) {
            JOptionPane.showMessageDialog(this, "You have no competition pilots.", "No competition data", 0);
            return;
        }
        File file = this.chooseFileExport("Select file name for exporting flight matrix", "Matrix");
        this.exportTable(this.matrixPane, file, "Matrix", -1, this.matrixPane.getTableModel().getColumnCount() - 1, null);
    }

    public void exportStartList() {
        if (this.competition.getCompetitorCount() == 0) {
            JOptionPane.showMessageDialog(this, "You have no competition pilots.", "No competition data", 0);
            return;
        }
        File file = this.chooseFileExport("Select file name for exporting start list", "StartList");
        this.exportTable(this.startListPane, file, "Start List", -1, this.startListPane.getTableModel().getColumnCount(), null);
    }

    public void exportRoundScores(Competition competition, AbstractF3KScoreEditorPanel roundsPane) {
        if (competition.getCompetitorCount() == 0) {
            if (competition.isFlyoffCompetition()) {
                JOptionPane.showMessageDialog(this, "You have no fly-off pilots.", "No competition data", 0);
            } else {
                JOptionPane.showMessageDialog(this, "You have no competition pilots.", "No competition data", 0);
            }
            return;
        }
        String sheetName = String.format("Round-%d", competition.getSelectedRoundIndex() + 1);
        if (competition.isFlyoffCompetition()) {
            sheetName = String.format("Flyoff-%d", competition.getSelectedRoundIndex() + 1);
        }
        File file = this.chooseFileExport("Select file name for exporting round scores", sheetName);
        this.exportTable(roundsPane, file, sheetName, -1, roundsPane.getTableModel().getColumnCount() - 1, null);
    }

    public void exportTotalScores(ArrayList<Integer> selectedTotalColumns, Competition competition, AbstractF3KScoreEditorPanel totalsPane) {
        if (competition.getCompetitorCount() == 0) {
            if (competition.isFlyoffCompetition()) {
                JOptionPane.showMessageDialog(this, "You have no fly-off pilots.", "No competition data", 0);
            } else {
                JOptionPane.showMessageDialog(this, "You have no competition pilots.", "No competition data", 0);
            }
            return;
        }
        String sheetName = "Totals";
        if (competition.isFlyoffCompetition()) {
            sheetName = "Flyoff-Totals";
        }
        File file = this.chooseFileExport("Select file name for exporting total scores", sheetName);
        this.exportTable(totalsPane, file, sheetName, -1, totalsPane.getTableModel().getColumnCount() - 1, selectedTotalColumns);
    }

    public void exportTotalScores(Competition competition, AbstractF3KScoreEditorPanel totalsPane) {
        this.exportTotalScores(null, competition, totalsPane);
    }

    public void exportTeamScores() {
        if (this.competition.getCompetitorCount() == 0) {
            JOptionPane.showMessageDialog(this, "You have no competition pilots.", "No competition data", 0);
            return;
        }
        if (!this.competition.haveTeams()) {
            JOptionPane.showMessageDialog(this, "Your competition has no teams defined", "No valid teams", 0);
            return;
        }
        File file = this.chooseFileExport("Select file name for exporting team scores", "Teams");
        this.exportTable(this.teamsPane, file, "Teams", -1, this.teamsPane.getTableModel().getColumnCount() - 1, null);
    }

    public void exportAllDataToExcelWorkbook() {
        if (this.competition.getCompetitorCount() == 0) {
            JOptionPane.showMessageDialog(this, "You have no competition pilots.", "No competition data", 0);
            return;
        }
        if (!ExcelSpreadsheetReader.excelLibsAvailable()) {
            JOptionPane.showMessageDialog(editor, String.format("Excel utilities are not available. Verify your install or F3KScore program.", new Object[0]), "Excel file write error", 0);
            return;
        }
        JFileChooser fileChooser = new JFileChooser(new File("."));
        fileChooser.setDialogTitle("Select file name for exporting all data");
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(this.xlsxFilter);
        fileChooser.setCurrentDirectory(this.currentDir);
        String name = this.competition.getCompetitionName();
        fileChooser.setSelectedFile(new File(name == null ? "Contest-data" : name));
        int returnVal = fileChooser.showDialog(this, "Export");
        File file = null;
        if (returnVal == 0) {
            int reply;
            this.currentDir = fileChooser.getCurrentDirectory();
            file = fileChooser.getSelectedFile();
            String ext = F3kFileFilter.getExtension(file);
            if (!ext.equalsIgnoreCase("xlsx")) {
                file = new File(String.valueOf(file.getAbsolutePath()) + ".xlsx");
            }
            if (file.exists() && (reply = JOptionPane.showConfirmDialog(this, "File \"" + file.getName() + "\" exists.\nDo you want to overwrite it?", "File exists", 0)) != 0) {
                return;
            }
        } else {
            return;
        }
        try {
            String sheetName;
            ExcelSpreadsheetWriter xlWriter = new ExcelSpreadsheetWriter();
            this.exportTableToExcelFile(this.registrationPane, "Pilot List", this.competition.getCompetitorCount(), this.registrationPane.getTableModel().getColumnCount(), xlWriter);
            this.exportTableToExcelFile(this.tasksPane, "Task List", -1, this.tasksPane.getTableModel().getColumnCount(), xlWriter);
            this.exportTableToExcelFile(this.matrixPane, "Flight Matrix", -1, this.matrixPane.getTableModel().getColumnCount() - 1, xlWriter);
            int roundIndex = 0;
            while (roundIndex < this.competition.getNumberOfRounds()) {
                ((RoundScoresPane)this.roundsPane).selectRound(roundIndex);
                ((RoundScoresPane)this.roundsPane).sortGroups(4);
                sheetName = String.format("Round-%d", roundIndex + 1);
                this.exportTableToExcelFile(this.roundsPane, sheetName, -1, this.roundsPane.getTableModel().getColumnCount() - 1, xlWriter);
                ++roundIndex;
            }
            this.exportTableToExcelFile(this.totalsPane, "Total Scores", -1, this.totalsPane.getTableModel().getColumnCount() - 1, xlWriter);
            this.exportTableToExcelFile(this.teamsPane, "Team Scores", -1, this.teamsPane.getTableModel().getColumnCount() - 1, xlWriter);
            if (this.competition.getFlyoffCompetition() != null) {
                roundIndex = 0;
                while (roundIndex < this.competition.getFlyoffCompetition().getNumberOfRounds()) {
                    ((RoundScoresPane)this.flyoffRoundsPane).selectRound(roundIndex);
                    ((RoundScoresPane)this.flyoffRoundsPane).sortGroups(4);
                    sheetName = String.format("Flyoff-%d", roundIndex + 1);
                    this.exportTableToExcelFile(this.flyoffRoundsPane, sheetName, -1, this.flyoffRoundsPane.getTableModel().getColumnCount() - 1, xlWriter);
                    ++roundIndex;
                }
                this.exportTableToExcelFile(this.flyoffTotalsPane, "Flyoff Total Scores", -1, this.flyoffTotalsPane.getTableModel().getColumnCount() - 1, xlWriter);
            }
            xlWriter.saveAs(file);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Failed when writing to file \"" + file.getName() + "\":\n\n" + ex.getLocalizedMessage());
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            String[] commands = new String[]{"cmd", "/c", "start", "\"\"", file.getCanonicalPath()};
            Runtime.getRuntime().exec(commands);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    public boolean exportF3XVaultDataFile(int division) {
        if (this.competition.getCompetitorCount() == 0 || this.competition.getDoneRoundCount() == 0) {
            JOptionPane.showMessageDialog(this, "You have no competition data to export.", "No competition data", 0);
            return false;
        }
        if (this.competition.getEventType() != 1 && this.competition.getEventType() != 5 && this.competition.getEventType() != 3 && this.competition.getEventType() != 4) {
            JOptionPane.showMessageDialog(this, String.format("Event type '%s' is not supported by F3XVault exporting tool", Competition.COMP_TYPE_NAMES[this.competition.getEventType()]), "Invalid event type", 0);
            return false;
        }
        if (division == -1) {
            int nDiv = 0;
            for (Competitor pilot : this.competition.getCompetitorList()) {
                if (pilot.getDivision() <= nDiv) continue;
                nDiv = pilot.getDivision();
            }
            if (nDiv > 0) {
                int reply = JOptionPane.showConfirmDialog(this, String.format("Your competition pilots are separated by class into %d divisions.\nEach division will be exported into a separate file (%d files total).\nContinue?", nDiv, nDiv), "Export data into multiple contest files?", 0);
                if (reply != 0) {
                    return false;
                }
                int div = 1;
                while (div <= nDiv) {
                    if (!this.exportF3XVaultDataFile(div)) {
                        return false;
                    }
                    ++div;
                }
                return true;
            }
        }
        JFileChooser fileChooser = new JFileChooser(new File("."));
        String title = "Select F3XVault file name";
        if (division > 0) {
            title = String.format("Select F3XVault file name for Division %d", division);
        }
        fileChooser.setDialogTitle(title);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.addChoosableFileFilter(this.csvFilter);
        fileChooser.setCurrentDirectory(this.currentDir);
        String name = this.competition.getCompetitionName();
        if (name == null) {
            name = "Contest-data";
        }
        if (division > 0) {
            name = String.format(String.valueOf(name) + "-div-%d", division);
        }
        fileChooser.setSelectedFile(new File(name));
        int returnVal = fileChooser.showDialog(this, "Export");
        File file = null;
        if (returnVal == 0) {
            int reply;
            this.currentDir = fileChooser.getCurrentDirectory();
            file = fileChooser.getSelectedFile();
            String ext = F3kFileFilter.getExtension(file);
            if (!ext.equalsIgnoreCase("csv")) {
                file = new File(String.valueOf(file.getAbsolutePath()) + ".csv");
            }
            if (file.exists() && (reply = JOptionPane.showConfirmDialog(this, "File \"" + file.getName() + "\" exists.\nDo you want to overwrite it?", "File exists", 0)) != 0) {
                return false;
            }
        } else {
            return false;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        CSVWriter writer = null;
        try {
            try {
                writer = new CSVWriter(new FileWriter(file));
                ArrayList<Object> data = new ArrayList<Object>();
                String eventType = "";
                if (this.competition.getEventType() == 1) {
                    eventType = "f3k";
                } else if (this.competition.getEventType() == 5) {
                    eventType = "f3j";
                } else if (this.competition.getEventType() == 3) {
                    eventType = "td";
                } else if (this.competition.getEventType() == 4) {
                    eventType = "f5j";
                }
                String[] eventLine = new String[]{String.valueOf(this.competition.getF3xvaultID()), this.competition.getCompetitionName() != null ? this.competition.getCompetitionName() : "", this.competition.getDate() != null ? this.competition.getDate() : "", this.competition.getEndDate() != null ? this.competition.getEndDate() : "", eventType};
                data.add(eventLine);
                String[] taskList = new String[this.competition.getDoneRoundCount()];
                int i = 0;
                while (i < this.competition.getDoneRoundCount()) {
                    taskList[i] = this.competition.getTaskList().get(i).getCodedName();
                    if (taskList[i] == null || eventType != "f3k") {
                        taskList[i] = this.competition.getTaskList().get(i).getShortName();
                    } else if (taskList[i].equals("f3j_10")) {
                        taskList[i] = "10:00";
                    } else if (taskList[i].equals("f3j_15")) {
                        taskList[i] = "15:00";
                    } else if (taskList[i].equals("ales_6")) {
                        taskList[i] = "6:00";
                    } else if (taskList[i].equals("ales_8")) {
                        taskList[i] = "8:00";
                    } else if (taskList[i].equals("ales_10")) {
                        taskList[i] = "10:00";
                    } else if (taskList[i].equals("ales_15")) {
                        taskList[i] = "15:00";
                    }
                    ++i;
                }
                data.add(taskList);
                for (Competitor pilot : this.competition.getCompetitorList()) {
                    if (division > 0 && pilot.getDivision() != division) continue;
                    ArrayList<String> pilotData = new ArrayList<String>();
                    data.add(pilotData);
                    pilotData.add(String.valueOf(pilot.getF3xvaultID()));
                    pilotData.add(pilot.getFullName());
                    pilotData.add(pilot.getCompetitorClass());
                    pilotData.add(pilot.getFrequency());
                    pilotData.add(pilot.getTeamName());
                    int roundIndex = 0;
                    while (roundIndex < this.competition.getDoneRoundCount()) {
                        boolean over;
                        int landing;
                        double seconds;
                        int minutes;
                        pilotData.add(Competition.groupNumberToLetter(pilot.getGroupNum(roundIndex)));
                        if (this.competition.getEventType() == 1) {
                            int flightIndex = 0;
                            while (flightIndex < this.competition.getTaskList().get(roundIndex).getNumFlights()) {
                                double taskTime = pilot.getTaskTime(roundIndex, flightIndex);
                                if (taskTime >= 0.0) {
                                    pilotData.add(String.valueOf(taskTime));
                                } else {
                                    pilotData.add("");
                                }
                                ++flightIndex;
                            }
                        } else if (this.competition.getEventType() == 5) {
                            double time = pilot.getTaskTime(roundIndex, 0);
                            minutes = (int)(time / 60.0);
                            seconds = time % 60.0;
                            landing = (int)pilot.getTaskTime(roundIndex, 1);
                            over = pilot.getTaskTime(roundIndex, 2) > 0.0;
                            pilotData.add(String.valueOf(minutes));
                            pilotData.add(String.valueOf(seconds));
                            pilotData.add(String.valueOf(landing));
                            pilotData.add(String.valueOf(over));
                        } else if (this.competition.getEventType() == 3) {
                            double time = pilot.getTaskTime(roundIndex, 0);
                            minutes = (int)(time / 60.0);
                            seconds = time % 60.0;
                            landing = (int)pilot.getTaskTime(roundIndex, 1);
                            over = false;
                            pilotData.add(String.valueOf(minutes));
                            pilotData.add(String.valueOf(seconds));
                            pilotData.add(String.valueOf(landing));
                            pilotData.add(String.valueOf(over));
                        } else if (this.competition.getEventType() == 4) {
                            double time = pilot.getTaskTime(roundIndex, 0);
                            if (time <= 0.0) {
                                pilotData.add("");
                                pilotData.add("");
                                pilotData.add("");
                                pilotData.add("");
                            } else {
                                minutes = (int)(time / 60.0);
                                seconds = time % 60.0;
                                landing = (int)pilot.getTaskTime(roundIndex, 1);
                                int launchHeight = (int)pilot.getTaskTime(roundIndex, 2);
                                pilotData.add(String.valueOf(minutes));
                                pilotData.add(String.valueOf(seconds));
                                pilotData.add(String.valueOf(landing));
                                pilotData.add(String.valueOf(launchHeight));
                            }
                        }
                        String penalty = "";
                        if (pilot.getPenalty(roundIndex) != 0) {
                            penalty = String.valueOf(pilot.getPenalty(roundIndex));
                        }
                        pilotData.add(penalty);
                        ++roundIndex;
                    }
                }
                writer.writeLines(data);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(editor, String.format("Failed when writing data to file \"%s\": %n%n%s", file.getName(), e.getLocalizedMessage()), "File write error", 0);
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.setCursor(Cursor.getDefaultCursor());
                return false;
            }
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (Exception exception) {}
            this.setCursor(Cursor.getDefaultCursor());
        }
        return true;
    }

    private void createMenuBar() {
        JMenu fileMenu = new JMenu("File");
        this.mainMenuBar.add(fileMenu);
        JMenu newMenu = new JMenu("New");
        fileMenu.add(newMenu);
        newMenu.add(new JMenuItem(new AbstractAction("F3K Competition"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.createNewCompetition(1);
            }
        }));
        newMenu.add(new JMenuItem(new AbstractAction("ALES Competition"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.createNewCompetition(2);
            }
        }));
        newMenu.add(new JMenuItem(new AbstractAction("TD Competition"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.createNewCompetition(3);
            }
        }));
        newMenu.add(new JMenuItem(new AbstractAction("F5J Competition"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.createNewCompetition(4);
            }
        }));
        newMenu.add(new JMenuItem(new AbstractAction("F3J Competition"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.createNewCompetition(5);
            }
        }));
        fileMenu.add(new JMenuItem(new AbstractAction("Open"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.chooseFileOpen();
            }
        }));
        JMenu importMenu = new JMenu("Import");
        fileMenu.add(importMenu);
        importMenu.add(new JMenuItem(new AbstractAction("Pilots from a database file"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, 2));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PilotsDatabaseUtils.importPilotList();
            }
        }));
        importMenu.add(new JMenuItem(new AbstractAction("Contest data from F3XVault file"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 2));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PilotsDatabaseUtils.importF3XVaultFile();
            }
        }));
        fileMenu.add(new JMenuItem(new AbstractAction("Save"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, 2));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.save(F3KScore.this.loadedFile);
            }
        }));
        fileMenu.add(new JMenuItem(new AbstractAction("Save as"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.saveAs();
            }
        }));
        fileMenu.add(new JMenuItem(new AbstractAction("Exit"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exitApplication();
            }
        }));
        JMenu editMenu = new JMenu("Edit");
        this.mainMenuBar.add(editMenu);
        editMenu.add(new JMenuItem(new AbstractAction("Options"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.showOptionsDialog();
            }
        }));
        JMenu dataMenu = new JMenu("Data");
        this.mainMenuBar.add(dataMenu);
        JMenu importMenu2 = new JMenu("Import");
        dataMenu.add(importMenu2);
        importMenu2.add(new JMenuItem(new AbstractAction("Pilots from a database file"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(73, 2));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PilotsDatabaseUtils.importPilotList();
            }
        }));
        importMenu2.add(new JMenuItem(new AbstractAction("Contest data from F3XVault file"){
            {
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, 2));
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                PilotsDatabaseUtils.importF3XVaultFile();
            }
        }));
        dataMenu.add(new JMenuItem(new AbstractAction("Clear all flight times"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int reply = JOptionPane.showConfirmDialog(F3KScore.this, "Clear all flight times?", "Confirm data deletion", 0);
                if (reply == 0) {
                    F3KScore.this.competition.clearAllFlightTimes();
                }
            }
        }));
        dataMenu.add(new JMenuItem(new AbstractAction("Generate random flight times"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int reply = JOptionPane.showConfirmDialog(F3KScore.this, "Generate random flight times?\nThis will clear all existing flight times!", "Confirm data deletion", 0);
                if (reply == 0) {
                    F3KScore.this.competition.generateRandomFlightTimes();
                }
            }
        }));
        JMenu sortMenu = new JMenu("Sort pilot list");
        dataMenu.add(sortMenu);
        JMenu sortIncreasing = new JMenu("increasing order (A...Z, 0...9)");
        sortMenu.add(sortIncreasing);
        sortIncreasing.add(new JMenuItem(new AbstractAction("Full Name"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotList("Name");
            }
        }));
        sortIncreasing.add(new JMenuItem(new AbstractAction("First Name"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotList("First Name");
            }
        }));
        sortIncreasing.add(new JMenuItem(new AbstractAction("Last Name"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotList("Last Name");
            }
        }));
        sortIncreasing.add(new JMenuItem(new AbstractAction("Tag"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotList("Tag");
            }
        }));
        sortIncreasing.add(new JMenuItem(new AbstractAction("Class"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotList("Class");
            }
        }));
        sortIncreasing.add(new JMenuItem(new AbstractAction("Freq 1"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotList("Freq 1");
            }
        }));
        sortIncreasing.add(new JMenuItem(new AbstractAction("Freq 2"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotList("Freq 2");
            }
        }));
        sortIncreasing.add(new JMenuItem(new AbstractAction("Team"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotList("Team");
            }
        }));
        sortIncreasing.add(new JMenuItem(new AbstractAction("FAI / AMA Num"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotList("FAI/AMA Num");
            }
        }));
        sortIncreasing.add(new JMenuItem(new AbstractAction("State"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotList("State");
            }
        }));
        sortIncreasing.add(new JMenuItem(new AbstractAction("Club"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotList("Club");
            }
        }));
        sortIncreasing.add(new JMenuItem(new AbstractAction("E-mail"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotList("E-mail");
            }
        }));
        sortIncreasing.add(new JMenuItem(new AbstractAction("Glider Models"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotList("Glider Models");
            }
        }));
        sortIncreasing.add(new JMenuItem(new AbstractAction("Info"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotList("Info");
            }
        }));
        sortIncreasing.add(new JMenuItem(new AbstractAction("Total Score"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotList("Total Score");
            }
        }));
        JMenu sortDecreasing = new JMenu("reverse order (Z...A, 9...0)");
        sortMenu.add(sortDecreasing);
        sortDecreasing.add(new JMenuItem(new AbstractAction("Full Name"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotListReverse("Name");
            }
        }));
        sortDecreasing.add(new JMenuItem(new AbstractAction("First Name"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotListReverse("First Name");
            }
        }));
        sortDecreasing.add(new JMenuItem(new AbstractAction("Last Name"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotListReverse("Last Name");
            }
        }));
        sortDecreasing.add(new JMenuItem(new AbstractAction("Tag"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotListReverse("Tag");
            }
        }));
        sortDecreasing.add(new JMenuItem(new AbstractAction("Class"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotListReverse("Class");
            }
        }));
        sortDecreasing.add(new JMenuItem(new AbstractAction("Freq 1"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotListReverse("Freq 1");
            }
        }));
        sortDecreasing.add(new JMenuItem(new AbstractAction("Freq 2"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotListReverse("Freq 2");
            }
        }));
        sortDecreasing.add(new JMenuItem(new AbstractAction("Team"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotListReverse("Team");
            }
        }));
        sortDecreasing.add(new JMenuItem(new AbstractAction("FAI / AMA Num"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotListReverse("FAI/AMA Num");
            }
        }));
        sortDecreasing.add(new JMenuItem(new AbstractAction("State"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotListReverse("State");
            }
        }));
        sortDecreasing.add(new JMenuItem(new AbstractAction("Club"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotListReverse("Club");
            }
        }));
        sortDecreasing.add(new JMenuItem(new AbstractAction("E-mail"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotListReverse("E-mail");
            }
        }));
        sortDecreasing.add(new JMenuItem(new AbstractAction("Glider Models"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotListReverse("Glider Models");
            }
        }));
        sortDecreasing.add(new JMenuItem(new AbstractAction("Info"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotListReverse("Info");
            }
        }));
        sortDecreasing.add(new JMenuItem(new AbstractAction("Total Score"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                F3KScore.this.sortPilotListReverse("Total Score");
            }
        }));
        this.printMenu = new JMenu("Print");
        this.mainMenuBar.add(this.printMenu);
        this.printMenu.add(new JMenuItem(new AbstractAction("Pilot list"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.showConfigureRegistrationColumnsDlg();
            }
        }));
        this.printMenu.add(new JMenuItem(new AbstractAction("Task list"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printTaskList();
            }
        }));
        this.printMenu.add(new JMenuItem(new AbstractAction("Flight matrix"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printFlightMatrix();
            }
        }));
        JMenu startListMenu = new JMenu("Start list");
        this.printMenu.add(startListMenu);
        startListMenu.add(new JMenuItem(new AbstractAction("All rounds"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printStartList(-1);
            }
        }));
        startListMenu.add(new JMenuItem(new AbstractAction("Currently selected round"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (F3KScore.this.competition != null) {
                    int ind = F3KScore.this.competition.getSelectedRoundIndex();
                    PrintUtils.printStartList(ind + 1);
                }
            }
        }));
        this.printRoundStartListMenu = new JMenu("Select a round");
        startListMenu.add(this.printRoundStartListMenu);
        JMenu scoreCardsMenu = new JMenu("Pilot score books");
        this.printMenu.add(scoreCardsMenu);
        JMenu allCardsMenu = new JMenu("All pilots, collated");
        scoreCardsMenu.add(allCardsMenu);
        allCardsMenu.add(new JMenuItem(new AbstractAction("8 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printScoreCards(8, F3KScore.this.competition);
            }
        }));
        allCardsMenu.add(new JMenuItem(new AbstractAction("6 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printScoreCards(6, F3KScore.this.competition);
            }
        }));
        allCardsMenu.add(new JMenuItem(new AbstractAction("4 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printScoreCards(4, F3KScore.this.competition);
            }
        }));
        allCardsMenu.add(new JMenuItem(new AbstractAction("2 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printScoreCards(2, F3KScore.this.competition);
            }
        }));
        JMenu selectedCardsMenu = new JMenu("Selected pilots only");
        scoreCardsMenu.add(selectedCardsMenu);
        selectedCardsMenu.add(new JMenuItem(new AbstractAction("8 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printSelectedPilotsScoreCards(8);
            }
        }));
        selectedCardsMenu.add(new JMenuItem(new AbstractAction("6 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printSelectedPilotsScoreCards(6);
            }
        }));
        selectedCardsMenu.add(new JMenuItem(new AbstractAction("4 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printSelectedPilotsScoreCards(4);
            }
        }));
        selectedCardsMenu.add(new JMenuItem(new AbstractAction("2 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printSelectedPilotsScoreCards(2);
            }
        }));
        JMenu scoreSheetsMenu = new JMenu("Pilot score sheets");
        this.printMenu.add(scoreSheetsMenu);
        scoreSheetsMenu.add(new JMenuItem(new AbstractAction("All pilots"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printScoreSheets(F3KScore.this.competition);
            }
        }));
        scoreSheetsMenu.add(new JMenuItem(new AbstractAction("Selected pilots only"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printSelectedPilotsScoreSheets();
            }
        }));
        JMenu officialCardsMenu = new JMenu("Official timechecker cards");
        this.printMenu.add(officialCardsMenu);
        JMenu allOfficialCardsMenu = new JMenu("All pilots, collated");
        officialCardsMenu.add(allOfficialCardsMenu);
        allOfficialCardsMenu.add(new JMenuItem(new AbstractAction("8 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printOfficialScoreCardsAllPilots(8);
            }
        }));
        allOfficialCardsMenu.add(new JMenuItem(new AbstractAction("6 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printOfficialScoreCardsAllPilots(6);
            }
        }));
        allOfficialCardsMenu.add(new JMenuItem(new AbstractAction("4 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printOfficialScoreCardsAllPilots(4);
            }
        }));
        allOfficialCardsMenu.add(new JMenuItem(new AbstractAction("2 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printOfficialScoreCardsAllPilots(2);
            }
        }));
        JMenu blankOfficialCardsMenu = new JMenu("Blank cards without pilot names");
        officialCardsMenu.add(blankOfficialCardsMenu);
        blankOfficialCardsMenu.add(new JMenuItem(new AbstractAction("8 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printOfficialScoreCards(8);
            }
        }));
        blankOfficialCardsMenu.add(new JMenuItem(new AbstractAction("6 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printOfficialScoreCards(6);
            }
        }));
        blankOfficialCardsMenu.add(new JMenuItem(new AbstractAction("4 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printOfficialScoreCards(4);
            }
        }));
        blankOfficialCardsMenu.add(new JMenuItem(new AbstractAction("2 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printOfficialScoreCards(2);
            }
        }));
        JMenu bibNumbersMenu = new JMenu("Pilot bib numbers");
        this.printMenu.add(bibNumbersMenu);
        bibNumbersMenu.add(new JMenuItem(new AbstractAction("Full page size"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printBibNumbersFullPage();
            }
        }));
        bibNumbersMenu.add(new JMenuItem(new AbstractAction("Half page size"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printBibNumbersHalfPage();
            }
        }));
        JMenu entrySheetsMenu = new JMenu("Score keeper entry sheet");
        this.printMenu.add(entrySheetsMenu);
        entrySheetsMenu.add(new JMenuItem(new AbstractAction("Currently selected round"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printScoreKeeperEntrySheet(F3KScore.this.competition, F3KScore.this.roundsPane);
            }
        }));
        this.printRoundScoreKeeperEntrySheetsMenu = new JMenu("Select a round");
        entrySheetsMenu.add(this.printRoundScoreKeeperEntrySheetsMenu);
        entrySheetsMenu.add(new JMenuItem(new AbstractAction("All rounds"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printScoreKeeperEntrySheet(true, F3KScore.this.competition, F3KScore.this.roundsPane);
            }
        }));
        JMenu roundScoresMenu = new JMenu("Round scores");
        this.printMenu.add(roundScoresMenu);
        roundScoresMenu.add(new JMenuItem(new AbstractAction("Currently selected round"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printSelectedRoundScores(F3KScore.this.competition, F3KScore.this.roundsPane);
            }
        }));
        this.printRoundScoresMenu = new JMenu("Select a round");
        roundScoresMenu.add(this.printRoundScoresMenu);
        roundScoresMenu.add(new JMenuItem(new AbstractAction("All rounds"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printSelectedRoundScores(true, F3KScore.this.competition, F3KScore.this.roundsPane);
            }
        }));
        JMenu totalScoresMenu = new JMenu("Total scores");
        this.printMenu.add(totalScoresMenu);
        totalScoresMenu.add(new JMenuItem(new AbstractAction("Select columns"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (F3KScore.this.showConfigureTotalColumnsDlg("Print", false)) {
                    PrintUtils.printTotalScores(F3KScore.this.printTotalColumns, F3KScore.this.competition, F3KScore.this.totalsPane);
                }
            }
        }));
        totalScoresMenu.add(new JMenuItem(new AbstractAction("All columns"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<Integer> printTotalColumns = new ArrayList<Integer>();
                int i = 0;
                while (i < F3KScore.this.totalsPane.getTable().getModel().getColumnCount() - 1) {
                    printTotalColumns.add(i);
                    ++i;
                }
                PrintUtils.printTotalScores(printTotalColumns, F3KScore.this.competition, F3KScore.this.totalsPane);
            }
        }));
        this.printMenu.add(new JMenuItem(new AbstractAction("Team scores"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!F3KScore.this.competition.haveTeams()) {
                    JOptionPane.showMessageDialog(F3KScore.this, "Your competition has no teams defined", "No valid teams", 0);
                    return;
                }
                PrintUtils.printTeamScores();
            }
        }));
        this.flyoffsPrintMenu = new JMenu("Fly-offs");
        this.printMenu.add(this.flyoffsPrintMenu);
        JMenu flyoffsScoreCardsMenu = new JMenu("Pilot score books");
        this.flyoffsPrintMenu.add(flyoffsScoreCardsMenu);
        flyoffsScoreCardsMenu.add(new JMenuItem(new AbstractAction("8 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printScoreCards(8, F3KScore.this.competition.getFlyoffCompetition());
            }
        }));
        flyoffsScoreCardsMenu.add(new JMenuItem(new AbstractAction("6 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printScoreCards(6, F3KScore.this.competition.getFlyoffCompetition());
            }
        }));
        flyoffsScoreCardsMenu.add(new JMenuItem(new AbstractAction("4 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printScoreCards(4, F3KScore.this.competition.getFlyoffCompetition());
            }
        }));
        flyoffsScoreCardsMenu.add(new JMenuItem(new AbstractAction("2 cards per page"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printScoreCards(2, F3KScore.this.competition.getFlyoffCompetition());
            }
        }));
        this.flyoffsPrintMenu.add(new JMenuItem(new AbstractAction("Pilot score sheets"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.printScoreSheets(F3KScore.this.competition.getFlyoffCompetition());
            }
        }));
        this.printFlyoffRoundScoresMenu = new JMenu("Round scores");
        this.flyoffsPrintMenu.add(this.printFlyoffRoundScoresMenu);
        this.printFlyoffRoundScoresMenu.add(new JMenuItem(new AbstractAction("Currently selected round"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printSelectedRoundScores(F3KScore.this.competition.getFlyoffCompetition(), F3KScore.this.flyoffRoundsPane);
            }
        }));
        this.printSelectFlyoffRoundSubMenu = new JMenu("Select a round");
        this.printFlyoffRoundScoresMenu.add(this.printSelectFlyoffRoundSubMenu);
        this.printFlyoffRoundScoresMenu.add(new JMenuItem(new AbstractAction("All rounds"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PrintUtils.printSelectedRoundScores(true, F3KScore.this.competition.getFlyoffCompetition(), F3KScore.this.flyoffRoundsPane);
            }
        }));
        this.printFlyoffTotalScoresMenu = new JMenu("Total scores");
        this.flyoffsPrintMenu.add(this.printFlyoffTotalScoresMenu);
        this.printFlyoffTotalScoresMenu.add(new JMenuItem(new AbstractAction("Select columns"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (F3KScore.this.showConfigureTotalColumnsDlg("Print", true)) {
                    PrintUtils.printTotalScores(F3KScore.this.printFlyoffTotalColumns, F3KScore.this.competition.getFlyoffCompetition(), F3KScore.this.flyoffTotalsPane);
                }
            }
        }));
        this.printFlyoffTotalScoresMenu.add(new JMenuItem(new AbstractAction("All columns"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<Integer> printTotalColumns = new ArrayList<Integer>();
                int i = 0;
                while (i < F3KScore.this.flyoffTotalsPane.getTable().getModel().getColumnCount() - 1) {
                    printTotalColumns.add(i);
                    ++i;
                }
                PrintUtils.printTotalScores(printTotalColumns, F3KScore.this.competition.getFlyoffCompetition(), F3KScore.this.flyoffTotalsPane);
            }
        }));
        JMenu exportMenu = new JMenu("Export");
        this.mainMenuBar.add(exportMenu);
        JMenu exportPilotListMenu = new JMenu("Pilot list");
        exportMenu.add(exportPilotListMenu);
        exportPilotListMenu.add(new JMenuItem(new AbstractAction("Create new database file"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exportPilotList();
            }
        }));
        exportPilotListMenu.add(new JMenuItem(new AbstractAction("Merge into existing database file"){

            @Override
            public void actionPerformed(ActionEvent e) {
                PilotsDatabaseUtils.mergePilotListToDatabaseFile();
            }
        }));
        exportMenu.add(new JMenuItem(new AbstractAction("Task list"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exportTaskList();
            }
        }));
        exportMenu.add(new JMenuItem(new AbstractAction("Flight matrix"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exportFlightMatrix();
            }
        }));
        exportMenu.add(new JMenuItem(new AbstractAction("Start list"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exportStartList();
            }
        }));
        JMenu exportRoundScoresMenu = new JMenu("Round scores");
        exportMenu.add(exportRoundScoresMenu);
        exportRoundScoresMenu.add(new JMenuItem(new AbstractAction("Currently selected round"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((RoundScoresPane)F3KScore.this.roundsPane).sortGroups(4);
                F3KScore.this.exportRoundScores(F3KScore.this.competition, F3KScore.this.roundsPane);
                ((RoundScoresPane)F3KScore.this.roundsPane).sortGroups(0);
            }
        }));
        this.exportRoundScoresSubMenu = new JMenu("Select a round");
        exportRoundScoresMenu.add(this.exportRoundScoresSubMenu);
        JMenu exportTotalScoresMenu = new JMenu("Total scores");
        exportMenu.add(exportTotalScoresMenu);
        exportTotalScoresMenu.add(new JMenuItem(new AbstractAction("Select columns"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (F3KScore.this.competition.getCompetitorCount() == 0) {
                    JOptionPane.showMessageDialog(F3KScore.this, "You have no competition pilots.", "No competition data", 0);
                    return;
                }
                if (F3KScore.this.showConfigureTotalColumnsDlg("Export", false)) {
                    F3KScore.this.exportTotalScores(F3KScore.this.printTotalColumns, F3KScore.this.competition, F3KScore.this.totalsPane);
                }
            }
        }));
        exportTotalScoresMenu.add(new JMenuItem(new AbstractAction("All columns"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exportTotalScores(F3KScore.this.competition, F3KScore.this.totalsPane);
            }
        }));
        exportMenu.add(new JMenuItem(new AbstractAction("Team scores"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exportTeamScores();
            }
        }));
        this.exportFlyoffRoundScoresMenu = new JMenu("Fly-off Round scores");
        exportMenu.add(this.exportFlyoffRoundScoresMenu);
        this.exportFlyoffRoundScoresMenu.add(new JMenuItem(new AbstractAction("Currently selected round"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((FlyoffRoundScoresPane)F3KScore.this.flyoffRoundsPane).sortGroups(4);
                F3KScore.this.exportRoundScores(F3KScore.this.competition.getFlyoffCompetition(), F3KScore.this.flyoffRoundsPane);
                ((FlyoffRoundScoresPane)F3KScore.this.flyoffRoundsPane).sortGroups(0);
            }
        }));
        this.exportSelectFlyoffRoundSubMenu = new JMenu("Select a round");
        this.exportFlyoffRoundScoresMenu.add(this.exportSelectFlyoffRoundSubMenu);
        this.exportFlyoffTotalScoresMenu = new JMenu("Fly-off Total scores");
        exportMenu.add(this.exportFlyoffTotalScoresMenu);
        this.exportFlyoffTotalScoresMenu.add(new JMenuItem(new AbstractAction("Select columns"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (F3KScore.this.competition.getFlyoffCompetition().getCompetitorCount() == 0) {
                    JOptionPane.showMessageDialog(F3KScore.this, "You have no fly-off pilots.", "No competition data", 0);
                    return;
                }
                if (F3KScore.this.showConfigureTotalColumnsDlg("Export", true)) {
                    F3KScore.this.exportTotalScores(F3KScore.this.printFlyoffTotalColumns, F3KScore.this.competition.getFlyoffCompetition(), F3KScore.this.flyoffTotalsPane);
                }
            }
        }));
        this.exportFlyoffTotalScoresMenu.add(new JMenuItem(new AbstractAction("All columns"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exportTotalScores(F3KScore.this.competition.getFlyoffCompetition(), F3KScore.this.flyoffTotalsPane);
            }
        }));
        exportMenu.add(new JMenuItem(new AbstractAction("All data as Excel workbook"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exportAllDataToExcelWorkbook();
            }
        }));
        exportMenu.add(new JMenuItem(new AbstractAction("Create F3XVault data file"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.exportF3XVaultDataFile(-1);
            }
        }));
        JMenu toolsMenu = new JMenu("Tools");
        this.mainMenuBar.add(toolsMenu);
        toolsMenu.add(new JMenuItem(new AbstractAction("Generate audio playlist"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (F3KScore.this.playlistDialog == null) {
                    F3KScore.this.playlistDialog = new PlaylistDialog(F3KScore.this);
                } else {
                    F3KScore.this.playlistDialog.setVisible(true);
                    F3KScore.this.playlistDialog.generatePlaylist();
                }
            }
        }));
        JMenu mergeMenu = new JMenu("Merge results into tour/series table");
        toolsMenu.add(mergeMenu);
        mergeMenu.add(new JMenuItem(new AbstractAction("Open existing tour/series results file"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeResultsUtils.mergeResults(F3KScore.this, true);
            }
        }));
        mergeMenu.add(new JMenuItem(new AbstractAction("Create new tour/series results file"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeResultsUtils.mergeResults(F3KScore.this, false);
            }
        }));
        JMenu mergeMenu2 = new JMenu("Merge results into team qualifications table");
        toolsMenu.add(mergeMenu2);
        mergeMenu2.add(new JMenuItem(new AbstractAction("Open existing team qualifications file"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeResultsUtils.mergeResults(F3KScore.this, true, true);
            }
        }));
        mergeMenu2.add(new JMenuItem(new AbstractAction("Create new team qualifications file"){

            @Override
            public void actionPerformed(ActionEvent e) {
                MergeResultsUtils.mergeResults(F3KScore.this, false, true);
            }
        }));
        toolsMenu.add(new JMenuItem(new AbstractAction("Add results from another contest"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.addResultsFromAnotherContest();
            }
        }));
        JMenu helpMenu = new JMenu("Help");
        this.mainMenuBar.add(helpMenu);
        helpMenu.add(new JMenuItem(new AbstractAction("Help"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.showHelpDialog();
            }
        }));
        helpMenu.add(new JMenuItem(new AbstractAction("About F3KScore"){

            @Override
            public void actionPerformed(ActionEvent e) {
                F3KScore.this.showAboutDialog();
            }
        }));
        this.setJMenuBar(this.mainMenuBar);
    }

    public void printSelectedPilotsScoreCards(int nCardsPerPage) {
        int[] selRows = this.registrationPane.getTable().getSelectedRows();
        if (selRows.length == 0) {
            JOptionPane.showMessageDialog(this, "Please, select pilot names on the \"Pilot List\" page first.", "No pilots selected", 0);
            return;
        }
        ArrayList<Competitor> selPilotList = new ArrayList<Competitor>();
        int i = 0;
        while (i < selRows.length) {
            selPilotList.add(this.competition.getCompetitor(selRows[i]));
            ++i;
        }
        PrintUtils.printScoreCardsSelectedPilot(selPilotList, nCardsPerPage, this.competition);
    }

    public void printScoreSheets(Competition competition) {
        PrintUtils.printScoreSheetsSelectedPilot(competition.getCompetitorList(), competition);
    }

    public void printSelectedPilotsScoreSheets() {
        int[] selRows = this.registrationPane.getTable().getSelectedRows();
        if (selRows.length == 0) {
            JOptionPane.showMessageDialog(this, "Please, select pilot names on the \"Pilot List\" page first.", "No pilots selected", 0);
            return;
        }
        ArrayList<Competitor> selPilotList = new ArrayList<Competitor>();
        int i = 0;
        while (i < selRows.length) {
            selPilotList.add(this.competition.getCompetitor(selRows[i]));
            ++i;
        }
        PrintUtils.printScoreSheetsSelectedPilot(selPilotList, this.competition);
    }

    protected void showConfigureRegistrationColumnsDlg() {
        JPanel panel = new JPanel(new GridBagLayout());
        int nCol = this.registrationPane.getTable().getModel().getColumnCount();
        if (this.printRegistrationColumns == null) {
            this.printRegistrationColumns = new ArrayList();
            int i = 0;
            while (i < nCol) {
                this.printRegistrationColumns.add(i);
                ++i;
            }
        }
        int row = 0;
        int col = 0;
        int maxRows = nCol / 2;
        ArrayList<JCheckBox> chkBoxList = new ArrayList<JCheckBox>();
        int i = 1;
        while (i < nCol) {
            String title = this.registrationPane.getTable().getModel().getColumnName(i).replace("\n", " ");
            JCheckBox chkBox = new JCheckBox(title, this.printRegistrationColumns.contains(i));
            chkBoxList.add(chkBox);
            panel.add((Component)chkBox, new GridBagConstraints(col, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 0, 0), 0, 0));
            if (row >= maxRows) {
                row = 0;
                col = 1;
            }
            ++i;
        }
        int reply = JOptionPane.showOptionDialog(this, panel, "Select \"Pilot List\" table columns", 2, -1, null, new String[]{"Print", "Cancel"}, null);
        if (reply == 0) {
            this.printRegistrationColumns.clear();
            this.printRegistrationColumns.add(0);
            int i2 = 1;
            while (i2 < nCol) {
                if (((JCheckBox)chkBoxList.get(i2 - 1)).isSelected()) {
                    this.printRegistrationColumns.add(i2);
                }
                ++i2;
            }
            PrintUtils.printPilotList(this.printRegistrationColumns, this.competition.getCompetitorCount());
        }
    }

    protected boolean showConfigureTotalColumnsDlg(String okButtonName, boolean flyoffScores) {
        int i;
        JPanel panel = new JPanel(new GridBagLayout());
        AbstractF3KScoreEditorPanel thePage = null;
        ArrayList<Integer> printColumns = null;
        int nCol = 0;
        String pageTitle = null;
        if (!flyoffScores) {
            thePage = this.totalsPane;
            nCol = thePage.getTable().getModel().getColumnCount();
            if (this.printTotalColumns == null) {
                this.printTotalColumns = new ArrayList();
                i = 1;
                while (i < nCol - 1) {
                    this.printTotalColumns.add(i);
                    ++i;
                }
            }
            printColumns = this.printTotalColumns;
            pageTitle = "Select \"Total Scores\" table columns";
        } else {
            thePage = this.flyoffTotalsPane;
            nCol = thePage.getTable().getModel().getColumnCount();
            if (this.printFlyoffTotalColumns == null) {
                this.printFlyoffTotalColumns = new ArrayList();
                i = 1;
                while (i < nCol - 1) {
                    this.printFlyoffTotalColumns.add(i);
                    ++i;
                }
            }
            printColumns = this.printFlyoffTotalColumns;
            pageTitle = "Select \"Fly-off Total Scores\" table columns";
        }
        int row = 0;
        int col = 0;
        double maxRows = (double)nCol / 2.0;
        ArrayList<JCheckBox> chkBoxList = new ArrayList<JCheckBox>();
        int i2 = 1;
        while (i2 < nCol - 1) {
            String title = thePage.getTable().getModel().getColumnName(i2).replace("\n", " ");
            JCheckBox chkBox = new JCheckBox(title, printColumns.contains(i2));
            chkBoxList.add(chkBox);
            panel.add((Component)chkBox, new GridBagConstraints(col, row++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 25, 0, 0), 0, 0));
            if ((double)(row + 1) >= maxRows) {
                row = 0;
                col = 1;
            }
            ++i2;
        }
        int reply = JOptionPane.showOptionDialog(this, panel, pageTitle, 2, -1, null, new String[]{okButtonName, "Cancel"}, null);
        if (reply == 0) {
            printColumns.clear();
            printColumns.add(0);
            int i3 = 1;
            while (i3 < nCol - 1) {
                if (((JCheckBox)chkBoxList.get(i3 - 1)).isSelected()) {
                    printColumns.add(i3);
                }
                ++i3;
            }
            return true;
        }
        return false;
    }

    public Competition createNewCompetition(int compType) {
        int reply;
        if (this.competition.changesMade() && (reply = JOptionPane.showConfirmDialog(this, "You are about to close your data.\nAll unsaved changes will be lost.\nContinue?", "Discard unsaved changes?", 0)) != 0) {
            return null;
        }
        this.competition = new Competition(this, compType);
        this.loadedFile = null;
        this.setTitle("F3KScore: " + this.competition.getCompetitionName());
        this.tabbedPane.setSelectedIndex(0);
        this.fireChangeEvent();
        return this.competition;
    }

    private boolean changeCompetitionType(int compType) {
        int reply;
        if (this.competition.getDoneRoundCount() > 0 && (reply = JOptionPane.showConfirmDialog(this, "You are about to lose your flight data.\nContinue?", "Discard flight time data?", 0)) != 0) {
            return false;
        }
        Competition oldComp = this.competition;
        this.competition = new Competition(this, compType);
        int roundCount = this.competition.getNumberOfRounds();
        this.loadedFile = null;
        this.setTitle("F3KScore: " + this.competition.getCompetitionName());
        for (Competitor pilot : oldComp.getCompetitorList()) {
            pilot.setCompetition(this.competition);
            pilot.setNumberOfRounds(0);
            pilot.setNumberOfRounds(roundCount);
            int r = 0;
            while (r < roundCount) {
                pilot.setGroupNum(r, 1);
                ++r;
            }
            pilot.setTeamName(pilot.getTeamName());
            this.competition.getCompetitorList().add(pilot);
        }
        if (oldComp.getDate() != null) {
            this.competition.setDate(oldComp.getDate());
        }
        if (oldComp.getEndDate() != null) {
            this.competition.setEndDate(oldComp.getEndDate());
        }
        this.competition.setResultsDirty();
        this.competition.changesMade();
        oldComp.getCompetitorList().clear();
        this.tabbedPane.setSelectedIndex(0);
        this.competition.setNumberOfRounds(roundCount);
        this.fireChangeEvent();
        return true;
    }

    private void chooseFileOpen() {
        int reply;
        if (this.competition.changesMade() && (reply = JOptionPane.showConfirmDialog(this, "You are about to close your data.\nAll unsaved changes will be lost.\nContinue?", "Discard unsaved changes?", 0)) != 0) {
            return;
        }
        JFileChooser fileChooser = new JFileChooser(new File("."));
        fileChooser.setDialogTitle("Select F3KScore file to open");
        fileChooser.setFileFilter(this.f3kFilter);
        fileChooser.setCurrentDirectory(this.currentDir);
        int returnVal = fileChooser.showDialog(this, "Open");
        if (returnVal == 0) {
            this.currentDir = fileChooser.getCurrentDirectory();
            File file = fileChooser.getSelectedFile();
            try {
                this.loadFromFile(file);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, String.format("Failed when trying to read file \"%s\"\nError message:\n\n%s", file.getName(), ex.getLocalizedMessage()), "Error reading data file", 0);
                ex.printStackTrace();
            }
        }
    }

    private void loadFromFile(File file) throws Exception {
        FileInputStream fs = null;
        ObjectInputStream ois = null;
        try {
            Date date;
            List<String> formatStrings;
            String dateString;
            fs = new FileInputStream(file);
            ois = new ObjectInputStream(fs);
            this.competition = (Competition)ois.readObject();
            this.competition.setEditor(this);
            this.competition.setResultsDirty();
            this.txtCompName.setText(this.competition.getCompetitionName());
            if (this.competition.getDate() != null) {
                dateString = this.competition.getDate();
                formatStrings = Arrays.asList("M/d/y", "M-d-y", "M.d.y", "M d y");
                date = null;
                for (String formatString : formatStrings) {
                    try {
                        date = new SimpleDateFormat(formatString).parse(dateString);
                        this.compStartDatePicker.setDate(date);
                        break;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            } else {
                this.compStartDatePicker.setDate(null);
            }
            if (this.competition.getEndDate() != null) {
                dateString = this.competition.getEndDate();
                formatStrings = Arrays.asList("M/d/yy", "M-d-yy", "M.d.yy", "M d yy");
                date = null;
                for (String formatString : formatStrings) {
                    try {
                        date = new SimpleDateFormat(formatString).parse(dateString);
                        this.compEndDatePicker.setDate(date);
                        break;
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                }
            } else {
                this.compEndDatePicker.setDate(null);
            }
            this.fireChangeEvent();
        }
        finally {
            if (fs != null) {
                try {
                    fs.close();
                }
                catch (Exception exception) {}
            }
        }
        this.loadedFile = file;
        this.setTitle(String.format("F3KScore: %s (%s)", this.competition.getCompetitionName(), this.loadedFile.getAbsolutePath()));
        this.tabbedPane.setSelectedIndex(0);
    }

    private void saveAs() {
        JFileChooser fileChooser = new JFileChooser(new File("."));
        fileChooser.setDialogTitle("Select file name for saving F3KScore data");
        fileChooser.setFileFilter(this.f3kFilter);
        fileChooser.setCurrentDirectory(this.currentDir);
        int returnVal = fileChooser.showDialog(this, "Save");
        if (returnVal == 0) {
            this.currentDir = fileChooser.getCurrentDirectory();
            File file = fileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            if (!F3kFileFilter.getExtension(file).equalsIgnoreCase("f3k")) {
                file = new File(String.valueOf(file.getAbsolutePath()) + ".f3k");
            }
            if (file.exists()) {
                int reply = JOptionPane.showConfirmDialog(this, String.format("File \"%s\" exists.\nDo you want to overwrite it?", file.getName()), "File exists", 1);
                if (reply == 1) {
                    this.saveAs();
                    return;
                }
                if (reply != 0) {
                    return;
                }
            }
            this.save(file);
        }
    }

    private void save(File file) {
        if (file == null) {
            this.saveAs();
            return;
        }
        if (this.competition.getCompetitionName() == null) {
            String name = file.getName();
            name = name.substring(0, name.length() - 4);
            this.competition.setCompetitionName(name);
            this.txtCompName.setText(name);
        }
        try {
            FileOutputStream fs = new FileOutputStream(file);
            ObjectOutputStream oos = new ObjectOutputStream(fs);
            oos.writeObject(this.competition);
            oos.close();
            this.competition.setChangesMade(false);
            this.loadedFile = file;
            this.setTitle(String.format("F3KScore: %s (%s)", this.competition.getCompetitionName(), this.loadedFile.getAbsolutePath()));
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, String.format("Failed when writing to file \"%s\":\n\n%s", file.getName(), ex.getLocalizedMessage()));
        }
    }

    public void fireChangeEvent() {
        if (this.competition.getFlyoffCompetition() != null && this.flyoffRoundsPane == null) {
            this.flyoffRoundsPane = new FlyoffRoundScoresPane(this.competition);
            this.editorPanels.add(this.flyoffRoundsPane);
            this.tabbedPane.addTab("Fly-off Round Scores", this.flyoffRoundsPane);
            this.flyoffTotalsPane = new FlyoffTotalScoresPane(this.competition);
            this.editorPanels.add(this.flyoffTotalsPane);
            this.tabbedPane.addTab("Fly-off Total Scores", this.flyoffTotalsPane);
        } else if (this.competition.getFlyoffCompetition() == null && this.flyoffRoundsPane != null) {
            this.editorPanels.remove(this.flyoffRoundsPane);
            this.tabbedPane.remove(this.flyoffRoundsPane);
            this.flyoffRoundsPane = null;
            this.editorPanels.remove(this.flyoffTotalsPane);
            this.tabbedPane.remove(this.flyoffTotalsPane);
            this.flyoffTotalsPane = null;
        }
        for (AbstractF3KScoreEditorPanel aPanel : this.editorPanels) {
            aPanel.dataStructureChanged(this.competition);
        }
        this.txtCompName.setText(this.competition.getCompetitionName());
        this.txtCompName.transferFocus();
        try {
            Date date;
            if (this.competition.getDate() != null) {
                date = new SimpleDateFormat("MM-dd-yyyy").parse(this.competition.getDate());
                this.compStartDatePicker.setDate(date);
            }
            if (this.competition.getEndDate() != null) {
                date = new SimpleDateFormat("MM-dd-yyyy").parse(this.competition.getEndDate());
                this.compEndDatePicker.setDate(date);
            }
        }
        catch (ParseException date) {
            // empty catch block
        }
        int eventType = this.competition.getEventType();
        this.typeSelector.setSelectedIndex(eventType);
        this.updatePrintRoundScoresMenu();
        this.updateFlyoffScoresMenu();
    }

    public void fireDataChangeEvent() {
        for (AbstractF3KScoreEditorPanel aPanel : this.editorPanels) {
            aPanel.dataChanged();
        }
        this.txtCompName.setText(this.competition.getCompetitionName());
        this.txtCompName.transferFocus();
        try {
            Date date;
            if (this.competition.getDate() != null) {
                date = new SimpleDateFormat("MM-dd-yyyy").parse(this.competition.getDate());
                this.compStartDatePicker.setDate(date);
            }
            if (this.competition.getEndDate() != null) {
                date = new SimpleDateFormat("MM-dd-yyyy").parse(this.competition.getEndDate());
                this.compEndDatePicker.setDate(date);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    private void showOptionsDialog() {
        JPanel panel = new JPanel(new GridBagLayout());
        int row = 0;
        JLabel lblLastNameFormat = new JLabel("Pilot name format in Round Scores and Total Scores tables:");
        JRadioButton radioLastCommaFirst = new JRadioButton("\"Last, First\" (\"Shmoe, Joe\")");
        JRadioButton radioFirstLast = new JRadioButton("\"First Last\" (\"Joe Shmoe\")");
        JPanel panel1 = new JPanel();
        panel1.add(radioFirstLast);
        panel1.add(radioLastCommaFirst);
        ButtonGroup group1 = new ButtonGroup();
        group1.add(radioFirstLast);
        group1.add(radioLastCommaFirst);
        radioLastCommaFirst.setSelected(this.competition.isUseLastCommaFirstNameFormat());
        radioFirstLast.setSelected(!this.competition.isUseLastCommaFirstNameFormat());
        panel.add((Component)lblLastNameFormat, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        panel.add((Component)panel1, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 5), 0, 0));
        JLabel lblGroupNameUseLetters = new JLabel("Group name format in Flight Matrix and Round Scores tables:");
        JRadioButton radioGroupNameLetters = new JRadioButton("Letters (A,B,C,...)");
        JRadioButton radioGroupNameNumbers = new JRadioButton("Numbers (1,2,3,...)");
        JPanel panel2 = new JPanel();
        panel2.add(radioGroupNameLetters);
        panel2.add(radioGroupNameNumbers);
        ButtonGroup group2 = new ButtonGroup();
        group2.add(radioGroupNameLetters);
        group2.add(radioGroupNameNumbers);
        radioGroupNameLetters.setSelected(this.competition.useLetterGroupNames());
        radioGroupNameNumbers.setSelected(!this.competition.useLetterGroupNames());
        panel.add((Component)lblGroupNameUseLetters, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        panel.add((Component)panel2, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 5), 0, 0));
        JLabel lblTimeFormat = new JLabel("Flight times format in Round Scores tables:");
        JRadioButton radioTimeUseMinSecs = new JRadioButton("Mins:Secs (\"1:23\")");
        JRadioButton radioTimeUseSeconds = new JRadioButton("Seconds only (\"83\")");
        JPanel panel3 = new JPanel();
        panel3.add(radioTimeUseMinSecs);
        panel3.add(radioTimeUseSeconds);
        ButtonGroup group3 = new ButtonGroup();
        group3.add(radioTimeUseMinSecs);
        group3.add(radioTimeUseSeconds);
        radioTimeUseMinSecs.setSelected(!this.competition.isUseSecondsForFlightTimes());
        radioTimeUseSeconds.setSelected(this.competition.isUseSecondsForFlightTimes());
        panel.add((Component)lblTimeFormat, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        panel.add((Component)panel3, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 5), 0, 0));
        JLabel lblDroppedRounds = new JLabel("Number of dropped scores:");
        final JRadioButton radioDroppedScoresNone = new JRadioButton("None");
        final JRadioButton radioDroppedScoresUseF3K = new JRadioButton("Use appropriate FAI event rules");
        JPanel customDroppedScores = new JPanel();
        JRadioButton radioDroppedScoresMax = new JRadioButton("Number of dropped scores:");
        final JTextField txtMaxDrops = new JTextField(3);
        customDroppedScores.add(radioDroppedScoresMax);
        customDroppedScores.add(txtMaxDrops);
        JPanel panel4 = new JPanel(new GridBagLayout());
        panel4.add((Component)radioDroppedScoresUseF3K, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        panel4.add((Component)radioDroppedScoresNone, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        panel4.add((Component)customDroppedScores, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        ButtonGroup group4 = new ButtonGroup();
        group4.add(radioDroppedScoresNone);
        group4.add(radioDroppedScoresMax);
        group4.add(radioDroppedScoresUseF3K);
        int maxDrops = this.competition.getMaxDroppedScores();
        radioDroppedScoresNone.setSelected(maxDrops == 0);
        radioDroppedScoresUseF3K.setSelected(maxDrops < 0);
        radioDroppedScoresMax.setSelected(maxDrops > 0);
        txtMaxDrops.setEnabled(maxDrops > 0);
        txtMaxDrops.setEditable(maxDrops > 0);
        if (maxDrops > 0) {
            txtMaxDrops.setText("" + maxDrops);
        }
        panel.add((Component)lblDroppedRounds, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        panel.add((Component)panel4, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 10, 5), 0, 0));
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (radioDroppedScoresNone.isSelected()) {
                    txtMaxDrops.setText(null);
                    txtMaxDrops.setEnabled(false);
                    txtMaxDrops.setEditable(false);
                } else if (radioDroppedScoresUseF3K.isSelected()) {
                    txtMaxDrops.setText(null);
                    txtMaxDrops.setEnabled(false);
                    txtMaxDrops.setEditable(false);
                } else {
                    txtMaxDrops.setEnabled(true);
                    txtMaxDrops.setEditable(true);
                    if (F3KScore.this.nDropRounds <= 0) {
                        F3KScore.this.nDropRounds = F3KScore.this.competition.getMaxDroppedScores();
                    }
                    if (F3KScore.this.nDropRounds <= 0) {
                        F3KScore.this.nDropRounds = 1;
                    }
                    txtMaxDrops.setText("" + F3KScore.this.nDropRounds);
                }
            }
        };
        radioDroppedScoresNone.addActionListener(listener);
        radioDroppedScoresUseF3K.addActionListener(listener);
        radioDroppedScoresMax.addActionListener(listener);
        int maxDrops2 = -1;
        final JRadioButton radioDroppedScoresNone2 = new JRadioButton("None");
        final JRadioButton radioDroppedScoresUseF3K2 = new JRadioButton("Use appropriate FAI event rules");
        JRadioButton radioDroppedScoresMax2 = new JRadioButton("Number of dropped scores:");
        JCheckBox chkboxPrelimsCarryOver = new JCheckBox("Preliminary scores carry over to fly-offs");
        final JTextField txtMaxDrops2 = new JTextField(3);
        if (this.competition.getFlyoffCompetition() != null) {
            JLabel lblDroppedRounds2 = new JLabel("Number of dropped scores in fly-offs:");
            JPanel customDroppedScores2 = new JPanel();
            customDroppedScores2.add(radioDroppedScoresMax2);
            customDroppedScores2.add(txtMaxDrops2);
            JPanel panel5 = new JPanel(new GridBagLayout());
            panel5.add((Component)radioDroppedScoresUseF3K2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            panel5.add((Component)radioDroppedScoresNone2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
            panel5.add((Component)customDroppedScores2, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            ButtonGroup group5 = new ButtonGroup();
            group5.add(radioDroppedScoresNone2);
            group5.add(radioDroppedScoresMax2);
            group5.add(radioDroppedScoresUseF3K2);
            maxDrops2 = this.competition.getFlyoffCompetition().getMaxDroppedScores();
            radioDroppedScoresNone2.setSelected(maxDrops2 == 0);
            radioDroppedScoresUseF3K2.setSelected(maxDrops2 < 0);
            radioDroppedScoresMax2.setSelected(maxDrops2 > 0);
            txtMaxDrops2.setEnabled(maxDrops2 > 0);
            txtMaxDrops2.setEditable(maxDrops2 > 0);
            if (maxDrops2 > 0) {
                txtMaxDrops2.setText("" + maxDrops2);
            }
            panel.add((Component)lblDroppedRounds2, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
            panel.add((Component)panel5, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 0, 5), 0, 0));
            ActionListener listener2 = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (radioDroppedScoresNone2.isSelected()) {
                        txtMaxDrops2.setText(null);
                        txtMaxDrops2.setEnabled(false);
                        txtMaxDrops2.setEditable(false);
                    } else if (radioDroppedScoresUseF3K2.isSelected()) {
                        txtMaxDrops2.setText(null);
                        txtMaxDrops2.setEnabled(false);
                        txtMaxDrops2.setEditable(false);
                    } else {
                        txtMaxDrops2.setEnabled(true);
                        txtMaxDrops2.setEditable(true);
                        if (F3KScore.this.nDropRounds2 <= 0) {
                            F3KScore.this.nDropRounds2 = F3KScore.this.competition.getFlyoffCompetition().getMaxDroppedScores();
                        }
                        if (F3KScore.this.nDropRounds2 <= 0) {
                            F3KScore.this.nDropRounds2 = 1;
                        }
                        txtMaxDrops2.setText("" + F3KScore.this.nDropRounds2);
                    }
                }
            };
            radioDroppedScoresNone2.addActionListener(listener2);
            radioDroppedScoresUseF3K2.addActionListener(listener2);
            radioDroppedScoresMax2.addActionListener(listener2);
            chkboxPrelimsCarryOver.setSelected(this.competition.getPrelimsCarryOver());
            panel.add((Component)chkboxPrelimsCarryOver, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 15, 5), 0, 0));
        }
        JLabel lblRoudOffDigits = new JLabel("Number of digits after the decimal sign for rounding off scores:");
        final JRadioButton radioRoundOffDigitsDefault = new JRadioButton("Use appropriate FAI event rules");
        JPanel customRoundOffDigitsPanel = new JPanel();
        JRadioButton radioRoundOffDigitsCustom = new JRadioButton("Number of digits:");
        final JTextField txtRoundOffDigits = new JTextField(3);
        customRoundOffDigitsPanel.add(radioRoundOffDigitsCustom);
        customRoundOffDigitsPanel.add(txtRoundOffDigits);
        JPanel panel6 = new JPanel(new GridBagLayout());
        panel6.add((Component)radioRoundOffDigitsDefault, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 5, 0, 0), 0, 0));
        panel6.add((Component)customRoundOffDigitsPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        ButtonGroup group6 = new ButtonGroup();
        group6.add(radioRoundOffDigitsDefault);
        group6.add(radioRoundOffDigitsCustom);
        int roundOffDigitsValue = this.competition.getRoundOffNumDigits();
        radioRoundOffDigitsDefault.setSelected(roundOffDigitsValue < 0);
        radioRoundOffDigitsCustom.setSelected(roundOffDigitsValue >= 0);
        txtRoundOffDigits.setEnabled(roundOffDigitsValue >= 0);
        txtRoundOffDigits.setEditable(roundOffDigitsValue >= 0);
        if (roundOffDigitsValue >= 0) {
            txtRoundOffDigits.setText("" + roundOffDigitsValue);
        }
        panel.add((Component)lblRoudOffDigits, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        panel.add((Component)panel6, new GridBagConstraints(0, row++, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 25, 10, 5), 0, 0));
        ActionListener listener3 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (radioRoundOffDigitsDefault.isSelected()) {
                    txtRoundOffDigits.setText(null);
                    txtRoundOffDigits.setEnabled(false);
                    txtRoundOffDigits.setEditable(false);
                } else {
                    txtRoundOffDigits.setEnabled(true);
                    txtRoundOffDigits.setEditable(true);
                    if (F3KScore.this.nRoundOffDigits < 0) {
                        F3KScore.this.nRoundOffDigits = F3KScore.this.competition.getRoundOffNumDigits();
                    }
                    if (F3KScore.this.nRoundOffDigits < 0) {
                        F3KScore.this.nRoundOffDigits = 1;
                    }
                    txtRoundOffDigits.setText("" + F3KScore.this.nRoundOffDigits);
                }
            }
        };
        radioRoundOffDigitsDefault.addActionListener(listener3);
        radioRoundOffDigitsCustom.addActionListener(listener3);
        int reply = JOptionPane.showConfirmDialog(this, panel, "Competition Options", 2, -1);
        if (reply == 0) {
            boolean useLastCommaFirst = radioLastCommaFirst.isSelected();
            if (this.competition.isUseLastCommaFirstNameFormat() != useLastCommaFirst) {
                this.competition.setUseLastCommaFirstNameFormat(useLastCommaFirst);
                this.competition.setChangesMade(true);
            }
            boolean useLetters = radioGroupNameLetters.isSelected();
            if (this.competition.useLetterGroupNames() != useLetters) {
                this.competition.setUseLetterGroupNames(useLetters);
                this.competition.setChangesMade(true);
            }
            boolean useSeconds = radioTimeUseSeconds.isSelected();
            if (this.competition.isUseSecondsForFlightTimes() != useSeconds) {
                this.competition.setUseSecondsForFlightTimes(useSeconds);
                this.competition.setChangesMade(true);
            }
            try {
                if (radioDroppedScoresNone.isSelected()) {
                    maxDrops = 0;
                } else if (radioDroppedScoresUseF3K.isSelected()) {
                    maxDrops = -1;
                } else {
                    maxDrops = Integer.parseInt(txtMaxDrops.getText());
                    if (maxDrops < 1 || maxDrops > 5) {
                        throw new NumberFormatException();
                    }
                    this.nDropRounds = maxDrops;
                }
                if (this.competition.getMaxDroppedScores() != maxDrops) {
                    this.competition.setMaxDroppedScores(maxDrops);
                    this.competition.setChangesMade(true);
                    this.competition.setResultsDirty();
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Invalid value for \"Maximum number of dropped scores\". \nMust be an integer between 1 and 5.", "Invalid value", 0);
            }
            if (this.competition.getFlyoffCompetition() != null) {
                try {
                    if (radioDroppedScoresNone2.isSelected()) {
                        maxDrops2 = 0;
                    } else if (radioDroppedScoresUseF3K2.isSelected()) {
                        maxDrops2 = -1;
                    } else {
                        maxDrops2 = Integer.parseInt(txtMaxDrops2.getText());
                        if (maxDrops2 < 1 || maxDrops2 > 5) {
                            throw new NumberFormatException();
                        }
                        this.nDropRounds2 = maxDrops2;
                    }
                    if (this.competition.getFlyoffCompetition().getMaxDroppedScores() != maxDrops2) {
                        this.competition.getFlyoffCompetition().setMaxDroppedScores(maxDrops2);
                        this.competition.setChangesMade(true);
                        this.competition.setResultsDirty();
                    }
                }
                catch (NumberFormatException e) {
                    JOptionPane.showMessageDialog(this, "Invalid value for \"Maximum number of dropped scores\". \nMust be an integer between 1 and 5.", "Invalid value", 0);
                }
                boolean prelimsCarryOver = chkboxPrelimsCarryOver.isSelected();
                if (this.competition.getPrelimsCarryOver() != prelimsCarryOver) {
                    this.competition.setPrelimsCarryOver(prelimsCarryOver);
                    this.competition.setChangesMade(true);
                    this.competition.setResultsDirty();
                }
            }
            try {
                if (radioRoundOffDigitsDefault.isSelected()) {
                    roundOffDigitsValue = -1;
                } else {
                    roundOffDigitsValue = Integer.parseInt(txtRoundOffDigits.getText());
                    if (roundOffDigitsValue < 0 || roundOffDigitsValue > 3) {
                        throw new NumberFormatException();
                    }
                    this.nRoundOffDigits = roundOffDigitsValue;
                }
                if (this.competition.getRoundOffNumDigits() != roundOffDigitsValue) {
                    this.competition.setRoundOffNumDigits(roundOffDigitsValue);
                    this.competition.setChangesMade(true);
                    this.competition.setResultsDirty();
                }
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(this, "Invalid value for \"Number of digits after the decimal\". \nMust be an integer between 0 and 3.", "Invalid value", 0);
            }
            if (this.competition.changesMade()) {
                this.fireDataChangeEvent();
            }
        }
    }

    private void showAboutDialog() {
        JDialog aboutDialog = new JDialog(this){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                g.setColor(Color.black);
                g.setFont(new Font("Serif", 1, 32));
                int x = 30;
                int y = 60;
                g.drawImage(F3KScore.this.f3kLogo, x, y, null);
                g.drawString("F3KScore", (x += 20) + 120, (y += 0) + 10);
                g.setFont(new Font("Serif", 1, 16));
                g.drawString("Version 8.25,   Oct-2025", x + 120, y + 30);
                g.drawString("F3K/F5J/F3J/ALES/TD Scoring Program", x + 120, y + 50);
                g.drawString("2010-2025,  Oleg Golovidov", x + 120, y + 70);
                g.drawString("2007-2009,  Peter Jubel", x + 120, y + 90);
            }
        };
        aboutDialog.setTitle("About F3KScore");
        aboutDialog.setSize(460, 200);
        aboutDialog.setResizable(false);
        aboutDialog.setLocationRelativeTo(this);
        aboutDialog.setModal(true);
        aboutDialog.setVisible(true);
    }

    private void showHelpDialog() {
        JEditorPane editorPane = new JEditorPane();
        editorPane.setEditable(false);
        editorPane.setContentType("text/html");
        URL helpURL = F3KScore.class.getResource("HelpInfo.html");
        if (helpURL != null) {
            try {
                editorPane.setPage(helpURL);
            }
            catch (IOException e) {
                System.err.println("Attempted to read a bad URL: " + helpURL);
            }
        } else {
            System.err.println("Couldn't find file: HelpInfo.html");
        }
        editorPane.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JScrollPane editorScrollPane = new JScrollPane(editorPane);
        editorScrollPane.setVerticalScrollBarPolicy(22);
        editorScrollPane.setPreferredSize(new Dimension(250, 145));
        editorScrollPane.setMinimumSize(new Dimension(10, 10));
        JDialog helpDlg = new JDialog((Frame)this, "F3KScore: Help");
        helpDlg.setSize(860, 650);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        if (screen.height < 700 || screen.width < 950) {
            helpDlg.setSize(screen.width * 9 / 10, screen.height * 9 / 10);
        }
        helpDlg.setLocationRelativeTo(this);
        helpDlg.add(editorScrollPane);
        helpDlg.setVisible(true);
    }

    private void addResultsFromAnotherContest() {
        if (this.competition.getCompetitorCount() == 0) {
            JOptionPane.showMessageDialog(this, "You have no competition data loaded.", "No competition data", 0);
            return;
        }
        Competition secondComp = null;
        JFileChooser fileChooser = new JFileChooser(new File("."));
        fileChooser.setDialogTitle("Select F3KScore file to open");
        fileChooser.setFileFilter(this.f3kFilter);
        fileChooser.setCurrentDirectory(this.currentDir);
        int returnVal = fileChooser.showDialog(this, "Open");
        if (returnVal != 0) {
            return;
        }
        this.currentDir = fileChooser.getCurrentDirectory();
        File file = fileChooser.getSelectedFile();
        try {
            FileInputStream fs = new FileInputStream(file);
            ObjectInputStream ois = new ObjectInputStream(fs);
            try {
                secondComp = (Competition)ois.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, String.format("Failed when trying to read file \"%s\" \nError message:\n\n\"%s", file.getName(), ex.getLocalizedMessage()), "Error reading data file", 0);
            return;
        }
        String name1 = this.competition.getCompetitionName();
        String name2 = secondComp.getCompetitionName();
        if (name1 != null && name2 != null) {
            this.txtCompName.setText(String.valueOf(name1) + " + " + name2);
            this.competition.setCompetitionName(String.valueOf(name1) + " + " + name2);
        }
        ArrayList<Competitor> secondDayOnly = new ArrayList<Competitor>();
        int nGroupsFirstDay = this.competition.getMaxGroupCount();
        List<String> propNames = Arrays.asList("Class", "Club", "State", "E-mail", "FAI/AMA Num", "Freq 1", "Freq 2", "Info", "Glider Models", "Team");
        for (Competitor secondDayPilot : secondComp.getCompetitorList()) {
            if (this.competition.getCompetitorList().contains(secondDayPilot)) continue;
            secondDayOnly.add(secondDayPilot);
            Competitor newPilot = new Competitor(this.competition, secondDayPilot.getProperty("First Name"), secondDayPilot.getProperty("Last Name"));
            this.competition.addCompetitor(newPilot);
            int roundIndex = 0;
            while (roundIndex < this.competition.getNumberOfRounds()) {
                newPilot.setGroupNum(roundIndex, nGroupsFirstDay + 1);
                ++roundIndex;
            }
            for (String propName : propNames) {
                newPilot.setProperty(propName, secondDayPilot.getProperty(propName));
            }
        }
        int nRoundsFirstDay = this.competition.getNumberOfRounds();
        int nNewRounds = secondComp.getNumberOfRounds();
        this.competition.setNumberOfRounds(nRoundsFirstDay + nNewRounds);
        int i = 0;
        while (i < nNewRounds) {
            int roundIndex = nRoundsFirstDay + i;
            this.competition.setRoundTask(roundIndex, secondComp.getRoundTask(i));
            ++i;
        }
        int nGroupsSecondDay = secondComp.getMaxGroupCount();
        for (Competitor pilot : this.competition.getCompetitorList()) {
            if (!secondComp.getCompetitorList().contains(pilot)) {
                int roundIndex = nRoundsFirstDay;
                while (roundIndex < nRoundsFirstDay + nNewRounds) {
                    pilot.setGroupNum(roundIndex, nGroupsSecondDay + 1);
                    ++roundIndex;
                }
                continue;
            }
            for (Competitor secondDayPilot : secondComp.getCompetitorList()) {
                if (!secondDayPilot.equals(pilot)) continue;
                int roundIndex = nRoundsFirstDay;
                while (roundIndex < nRoundsFirstDay + nNewRounds) {
                    double aTime;
                    int group = secondDayPilot.getGroupNum(roundIndex - nRoundsFirstDay);
                    pilot.setGroupNum(roundIndex, group);
                    int nFlights = this.competition.getRoundTask(roundIndex).getNumFlights();
                    int i2 = 0;
                    while (i2 < nFlights) {
                        aTime = secondDayPilot.getTaskTime(roundIndex - nRoundsFirstDay, i2);
                        pilot.setTaskTime(roundIndex, i2, aTime);
                        ++i2;
                    }
                    pilot.setPenalty(roundIndex, secondDayPilot.getPenalty(roundIndex - nRoundsFirstDay));
                    if (secondDayPilot.isIncludedInReflightGroup(roundIndex - nRoundsFirstDay)) {
                        pilot.includeInReflightGroup(roundIndex, true);
                        i2 = 0;
                        while (i2 < nFlights) {
                            aTime = secondDayPilot.getReflightTime(roundIndex - nRoundsFirstDay, i2);
                            pilot.setReflightTime(roundIndex, i2, aTime);
                            ++i2;
                        }
                        pilot.setReflightPenalty(roundIndex, secondDayPilot.getReflightPenalty(roundIndex - nRoundsFirstDay));
                    }
                    ++roundIndex;
                }
                for (String propName : propNames) {
                    String val = pilot.getProperty(propName);
                    if (val != null && !val.equals("")) continue;
                    pilot.setProperty(propName, secondDayPilot.getProperty(propName));
                }
            }
        }
        this.competition.setResultsDirty();
        this.tabbedPane.setSelectedIndex(0);
        this.fireChangeEvent();
    }

    public void sortPilotList(final String keyName) {
        Comparator<Competitor> sorter = new Comparator<Competitor>(){

            @Override
            public int compare(Competitor o1, Competitor o2) {
                if (keyName.equals("Total Score")) {
                    double score2;
                    double score1 = o1.calculateTotalScore();
                    if (score1 > (score2 = o2.calculateTotalScore())) {
                        return 1;
                    }
                    if (score1 < score2) {
                        return -1;
                    }
                    return 0;
                }
                String val1 = o1.getProperty(keyName);
                String val2 = o2.getProperty(keyName);
                if (val1.length() == 0 && val2.length() > 0) {
                    return 1;
                }
                if (val1.length() > 0 && val2.length() == 0) {
                    return -1;
                }
                return val1.compareToIgnoreCase(val2);
            }
        };
        Collections.sort(this.competition.getCompetitorList(), sorter);
        this.competition.setResultsDirty();
        this.fireDataChangeEvent();
    }

    public void sortPilotListReverse(final String keyName) {
        Comparator<Competitor> sorter = new Comparator<Competitor>(){

            @Override
            public int compare(Competitor o1, Competitor o2) {
                if (keyName.equals("Total Score")) {
                    double score2;
                    double score1 = o1.calculateTotalScore();
                    if (score1 > (score2 = o2.calculateTotalScore())) {
                        return -1;
                    }
                    if (score1 < score2) {
                        return 1;
                    }
                    return 0;
                }
                String val1 = o1.getProperty(keyName);
                String val2 = o2.getProperty(keyName);
                if (val1.length() == 0 && val2.length() > 0) {
                    return 1;
                }
                if (val1.length() > 0 && val2.length() == 0) {
                    return -1;
                }
                return -1 * val1.compareToIgnoreCase(val2);
            }
        };
        Collections.sort(this.competition.getCompetitorList(), sorter);
        this.competition.setResultsDirty();
        this.fireDataChangeEvent();
    }

    private void updatePrintRoundScoresMenu() {
        this.printRoundScoresMenu.removeAll();
        this.exportRoundScoresSubMenu.removeAll();
        this.printRoundStartListMenu.removeAll();
        this.printRoundScoreKeeperEntrySheetsMenu.removeAll();
        if (this.competition != null) {
            int i = 0;
            while (i < this.competition.getNumberOfRounds()) {
                final int ind = i++;
                String title = String.format("Round %d", ind + 1);
                this.printRoundScoresMenu.add(new JMenuItem(new AbstractAction(title){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int selIndex = F3KScore.this.competition.getSelectedRoundIndex();
                        ((RoundScoresPane)F3KScore.this.roundsPane).selectRound(ind);
                        PrintUtils.printSelectedRoundScores(F3KScore.this.competition, F3KScore.this.roundsPane);
                        ((RoundScoresPane)F3KScore.this.roundsPane).selectRound(selIndex);
                    }
                }));
                this.exportRoundScoresSubMenu.add(new JMenuItem(new AbstractAction(title){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int selIndex = F3KScore.this.competition.getSelectedRoundIndex();
                        ((RoundScoresPane)F3KScore.this.roundsPane).selectRound(ind);
                        ((RoundScoresPane)F3KScore.this.roundsPane).sortGroups(4);
                        F3KScore.this.exportRoundScores(F3KScore.this.competition, F3KScore.this.roundsPane);
                        ((RoundScoresPane)F3KScore.this.roundsPane).selectRound(selIndex);
                    }
                }));
                this.printRoundStartListMenu.add(new JMenuItem(new AbstractAction(title){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PrintUtils.printStartList(ind + 1);
                    }
                }));
                this.printRoundScoreKeeperEntrySheetsMenu.add(new JMenuItem(new AbstractAction(title){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int selIndex = F3KScore.this.competition.getSelectedRoundIndex();
                        ((RoundScoresPane)F3KScore.this.roundsPane).selectRound(ind);
                        PrintUtils.printScoreKeeperEntrySheet(F3KScore.this.competition, F3KScore.this.roundsPane);
                        ((RoundScoresPane)F3KScore.this.roundsPane).selectRound(selIndex);
                    }
                }));
            }
        }
    }

    private void updateFlyoffScoresMenu() {
        this.printSelectFlyoffRoundSubMenu.removeAll();
        this.exportSelectFlyoffRoundSubMenu.removeAll();
        if (this.competition != null && this.competition.getFlyoffCompetition() != null) {
            this.flyoffsPrintMenu.setEnabled(true);
            this.exportFlyoffRoundScoresMenu.setEnabled(true);
            this.exportFlyoffTotalScoresMenu.setEnabled(true);
            int i = 0;
            while (i < this.competition.getFlyoffCompetition().getNumberOfRounds()) {
                final int ind = i++;
                String title = String.format("Round %d", ind + 1);
                this.printSelectFlyoffRoundSubMenu.add(new JMenuItem(new AbstractAction(title){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int selIndex = F3KScore.this.competition.getFlyoffCompetition().getSelectedRoundIndex();
                        ((FlyoffRoundScoresPane)F3KScore.this.flyoffRoundsPane).selectRound(ind);
                        PrintUtils.printSelectedRoundScores(F3KScore.this.competition.getFlyoffCompetition(), F3KScore.this.flyoffRoundsPane);
                        ((FlyoffRoundScoresPane)F3KScore.this.flyoffRoundsPane).selectRound(selIndex);
                    }
                }));
                this.exportSelectFlyoffRoundSubMenu.add(new JMenuItem(new AbstractAction(title){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int selIndex = F3KScore.this.competition.getFlyoffCompetition().getSelectedRoundIndex();
                        ((FlyoffRoundScoresPane)F3KScore.this.flyoffRoundsPane).selectRound(ind);
                        ((FlyoffRoundScoresPane)F3KScore.this.flyoffRoundsPane).sortGroups(4);
                        F3KScore.this.exportRoundScores(F3KScore.this.competition.getFlyoffCompetition(), F3KScore.this.flyoffRoundsPane);
                        ((FlyoffRoundScoresPane)F3KScore.this.flyoffRoundsPane).selectRound(selIndex);
                    }
                }));
            }
        } else {
            this.flyoffsPrintMenu.setEnabled(false);
            this.exportFlyoffRoundScoresMenu.setEnabled(false);
            this.exportFlyoffTotalScoresMenu.setEnabled(false);
        }
    }

    public static String stackTraceToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }
}

