/*
 * Decompiled with CFR 0.152.
 */
package f3kscore;

import f3kscore.Competition;
import f3kscore.Competitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class CompetitorGroup {
    public static final int SORT_GROUP_NONE = 0;
    public static final int SORT_GROUP_SHUFFLE = 1;
    public static final int SORT_GROUP_TOTAL_SCORE_INCREASING = 2;
    public static final int SORT_GROUP_TOTAL_SCORE_DECREASING = 3;
    public static final int SORT_GROUP_ROUND_SCORE_DECREASING = 4;
    public static final int SORT_GROUP_ROUND_SCORE_INCREASING = 5;
    private ArrayList<Competitor> groupList;
    private int competitorCount;
    private final int groupNumber;
    private final int roundIndex;
    private final Competition competition;

    public String getGroupName() {
        return this.competition.formatGroupNumberAsString(this.groupNumber);
    }

    public int getRoundIndex() {
        return this.roundIndex;
    }

    public Competitor getCompetitor(int index) {
        if (index >= this.groupList.size()) {
            return null;
        }
        return this.groupList.get(index);
    }

    public int getCompetitorCount() {
        return this.competitorCount;
    }

    public CompetitorGroup(Competition comp, int groupNumber, int roundIndex) {
        this.groupNumber = groupNumber;
        this.roundIndex = roundIndex;
        this.competition = comp;
        this.groupList = new ArrayList();
        int c = 0;
        while (c < comp.getCompetitorCount()) {
            if (groupNumber >= 0 && comp.getCompetitor(c).getGroupNum(roundIndex) == groupNumber) {
                this.groupList.add(comp.getCompetitor(c));
            } else if (groupNumber < 0 && comp.getCompetitor(c).isIncludedInReflightGroup(roundIndex)) {
                this.groupList.add(comp.getCompetitor(c));
            }
            ++c;
        }
        this.competitorCount = this.groupList.size();
    }

    public CompetitorGroup(Competition comp, int groupNumber, int roundIndex, boolean shuffle) {
        this(comp, groupNumber, roundIndex);
        if (shuffle) {
            this.shuffle();
        }
    }

    public CompetitorGroup(Competition comp, int groupNumber, int roundIndex, int sortOrder) {
        this(comp, groupNumber, roundIndex);
        switch (sortOrder) {
            case 1: {
                this.shuffle();
                return;
            }
            case 2: {
                this.sortByTotalScore(true);
                return;
            }
            case 3: {
                this.sortByTotalScore(false);
                return;
            }
            case 5: {
                this.sortByRoundScore(true);
                return;
            }
            case 4: {
                this.sortByRoundScore(false);
                return;
            }
        }
    }

    public CompetitorGroup shuffle() {
        ArrayList<Competitor> groupList2 = this.groupList;
        this.groupList = new ArrayList();
        int shift = (this.groupNumber + 17) * this.roundIndex;
        int c = 0;
        while (c < this.competitorCount) {
            this.groupList.add(groupList2.get((c + shift) % this.competitorCount));
            ++c;
        }
        return this;
    }

    public CompetitorGroup sortByTotalScore(final boolean increasing) {
        Collections.sort(this.groupList, new Comparator<Competitor>(){

            @Override
            public int compare(Competitor o1, Competitor o2) {
                double o1Score = o1.calculateTotalScore();
                double o2Score = o2.calculateTotalScore();
                if (!increasing) {
                    if (o1Score > o2Score) {
                        return -1;
                    }
                    if (o1Score < o2Score) {
                        return 1;
                    }
                    return 0;
                }
                if (o1Score < o2Score) {
                    return -1;
                }
                if (o1Score > o2Score) {
                    return 1;
                }
                return 0;
            }
        });
        return this;
    }

    public CompetitorGroup sortByRoundScore(final boolean increasing) {
        Collections.sort(this.groupList, new Comparator<Competitor>(){

            @Override
            public int compare(Competitor o1, Competitor o2) {
                double o1Score = o1.getRoundScore(CompetitorGroup.this.roundIndex);
                double o2Score = o2.getRoundScore(CompetitorGroup.this.roundIndex);
                if (!increasing) {
                    if (o1Score > o2Score) {
                        return -1;
                    }
                    if (o1Score < o2Score) {
                        return 1;
                    }
                    return 0;
                }
                if (o1Score < o2Score) {
                    return -1;
                }
                if (o1Score > o2Score) {
                    return 1;
                }
                return 0;
            }
        });
        return this;
    }
}

